/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinitionResource;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;

public final class LDAPProfile {
    private static final LDAPProfile INSTANCE = new LDAPProfile();
    private final LinkedList<Wrapper> profiles = new LinkedList();
    private final ManagedObjectDefinitionResource resource = ManagedObjectDefinitionResource.createForProfile("ldap");

    public static LDAPProfile getInstance() {
        return INSTANCE;
    }

    private LDAPProfile() {
    }

    public String getAttributeName(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
        for (Wrapper profile : this.profiles) {
            String attributeName = profile.getAttributeName(d, pd);
            if (attributeName == null) continue;
            return attributeName;
        }
        return this.resource.getString(d, "attribute." + pd.getName());
    }

    public String getRelationChildRDNType(InstantiableRelationDefinition<?, ?> r) {
        if (r.getNamingPropertyDefinition() != null) {
            return this.getAttributeName(r.getChildDefinition(), r.getNamingPropertyDefinition());
        }
        for (Wrapper profile : this.profiles) {
            String rdnType = profile.getRelationChildRDNType(r);
            if (rdnType == null) continue;
            return rdnType;
        }
        return this.resource.getString(r.getParentDefinition(), "naming-attribute." + r.getName());
    }

    public List<String> getRelationObjectClasses(RelationDefinition<?, ?> r) {
        return Arrays.asList("top", "ds-cfg-branch");
    }

    public String getRelationChildRDNType(SetRelationDefinition<?, ?> r) {
        for (Wrapper profile : this.profiles) {
            String rdnType = profile.getRelationChildRDNType(r);
            if (rdnType == null) continue;
            return rdnType;
        }
        return this.resource.getString(r.getParentDefinition(), "naming-attribute." + r.getName());
    }

    public String getObjectClass(AbstractManagedObjectDefinition<?, ?> d) {
        if (d.isTop()) {
            return "top";
        }
        for (Wrapper profile : this.profiles) {
            String objectClass = profile.getObjectClass(d);
            if (objectClass == null) continue;
            return objectClass;
        }
        return this.resource.getString(d, "objectclass");
    }

    public List<String> getObjectClasses(AbstractManagedObjectDefinition<?, ?> d) {
        LinkedList<String> objectClasses = new LinkedList<String>();
        HashSet<String> s = new HashSet<String>();
        while (d != null) {
            String oc = this.getObjectClass(d);
            if (s.add(oc)) {
                objectClasses.addFirst(oc);
            }
            d = d.getParent();
        }
        if (!s.contains("top")) {
            objectClasses.addFirst("top");
        }
        return objectClasses;
    }

    public String getRelationRDNSequence(RelationDefinition<?, ?> r) {
        for (Wrapper profile : this.profiles) {
            String rdnSequence = profile.getRelationRDNSequence(r);
            if (rdnSequence == null) continue;
            return rdnSequence;
        }
        return this.resource.getString(r.getParentDefinition(), "rdn." + r.getName());
    }

    public void popWrapper() {
        this.profiles.removeFirst();
    }

    public void pushWrapper(Wrapper wrapper) {
        this.profiles.addFirst(wrapper);
    }

    public static abstract class Wrapper {
        protected Wrapper() {
        }

        public String getAttributeName(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
            return null;
        }

        public String getRelationChildRDNType(InstantiableRelationDefinition<?, ?> r) {
            return null;
        }

        public String getRelationChildRDNType(SetRelationDefinition<?, ?> r) {
            return null;
        }

        public String getObjectClass(AbstractManagedObjectDefinition<?, ?> d) {
            return null;
        }

        public String getRelationRDNSequence(RelationDefinition<?, ?> r) {
            return null;
        }
    }
}

