/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class IPAddressPropertyDefinition
extends PropertyDefinition<InetAddress> {
    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private IPAddressPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<InetAddress> defaultBehavior) {
        super(d, InetAddress.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public void validateValue(InetAddress value) {
        Reject.ifNull((Object)value);
    }

    @Override
    public InetAddress decodeValue(String value) {
        Reject.ifNull((Object)value);
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public String encodeValue(InetAddress value) {
        String s = value.toString();
        int i = s.indexOf(47);
        if (i > 0) {
            return s.substring(0, i);
        }
        return value.getHostAddress();
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitIPAddress(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, InetAddress value, P p) {
        return v.visitIPAddress(this, value, p);
    }

    @Override
    public int compare(InetAddress o1, InetAddress o2) {
        return o1.getHostAddress().compareTo(o2.getHostAddress());
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<InetAddress, IPAddressPropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected IPAddressPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<InetAddress> defaultBehavior) {
            return new IPAddressPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

