/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.DecodingException;

public class DefinitionDecodingException
extends DecodingException {
    private static final long serialVersionUID = 3459033551415663416L;
    private final AbstractManagedObjectDefinition<?, ?> d;
    private final Reason reason;

    private static LocalizableMessage createLocalizableMessage(AbstractManagedObjectDefinition<?, ?> d, Reason reason) {
        LocalizableMessage ufn = d.getUserFriendlyName();
        switch (reason) {
            case NO_TYPE_INFORMATION: {
                return ConfigMessages.ERR_DECODING_EXCEPTION_NO_TYPE_INFO.get((Object)ufn);
            }
            case WRONG_TYPE_INFORMATION: {
                return ConfigMessages.ERR_DECODING_EXCEPTION_WRONG_TYPE_INFO.get((Object)ufn);
            }
        }
        return ConfigMessages.ERR_DECODING_EXCEPTION_ABSTRACT_TYPE_INFO.get((Object)ufn);
    }

    public DefinitionDecodingException(AbstractManagedObjectDefinition<?, ?> d, Reason reason) {
        super(DefinitionDecodingException.createLocalizableMessage(d, reason));
        this.d = d;
        this.reason = reason;
    }

    public AbstractManagedObjectDefinition<?, ?> getManagedObjectDefinition() {
        return this.d;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        ABSTRACT_TYPE_INFORMATION,
        NO_TYPE_INFORMATION,
        WRONG_TYPE_INFORMATION;

    }
}

