/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.ConfigurationFramework;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class ClassPropertyDefinition
extends PropertyDefinition<String> {
    private static final String CLASS_RE = "^([A-Za-z][A-Za-z0-9_]*\\.)*[A-Za-z][A-Za-z0-9_]*(\\$[A-Za-z0-9_]+)*$";
    private final List<String> instanceOfInterfaces;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private static Class<?> loadClass(String className, boolean initialize) throws ClassNotFoundException {
        return Class.forName(className, initialize, ConfigurationFramework.getInstance().getClassLoader());
    }

    private ClassPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior, List<String> instanceOfInterfaces) {
        super(d, String.class, propertyName, options, adminAction, defaultBehavior);
        this.instanceOfInterfaces = Collections.unmodifiableList(new LinkedList<String>(instanceOfInterfaces));
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitClass(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, String value, P p) {
        return v.visitClass(this, value, p);
    }

    @Override
    public String decodeValue(String value) {
        Reject.ifNull((Object)value);
        try {
            this.validateValue(value);
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value, e.getCause());
        }
        return value;
    }

    public List<String> getInstanceOfInterface() {
        return this.instanceOfInterfaces;
    }

    public <T> Class<? extends T> loadClass(String className, Class<T> instanceOf) {
        Reject.ifNull((Object[])new Serializable[]{className, instanceOf});
        this.validateClassName(className);
        Class<?> theClass = this.validateClassInterfaces(className, true);
        return theClass.asSubclass(instanceOf);
    }

    @Override
    public String normalizeValue(String value) {
        Reject.ifNull((Object)value);
        return value.trim();
    }

    @Override
    public void validateValue(String value) {
        Reject.ifNull((Object)value);
        this.validateClassName(value);
        if (!ConfigurationFramework.getInstance().isClient()) {
            this.validateClassInterfaces(value, false);
        }
    }

    private void validateClassName(String className) {
        String nvalue = className.trim();
        if (!nvalue.matches(CLASS_RE)) {
            throw PropertyException.illegalPropertyValueException(this, className);
        }
    }

    private Class<?> validateClassInterfaces(String className, boolean initialize) {
        Class<?> theClass = this.loadClassForValidation(className, className, initialize);
        for (String i : this.instanceOfInterfaces) {
            Class<?> instanceOfClass = this.loadClassForValidation(className, i, initialize);
            if (instanceOfClass.isAssignableFrom(theClass)) continue;
            throw PropertyException.illegalPropertyValueException(this, className);
        }
        return theClass;
    }

    private Class<?> loadClassForValidation(String componentClassName, String classToBeLoaded, boolean initialize) {
        try {
            return ClassPropertyDefinition.loadClass(classToBeLoaded.trim(), initialize);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw PropertyException.illegalPropertyValueException(this, componentClassName, e);
        }
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<String, ClassPropertyDefinition> {
        private final List<String> instanceOfInterfaces = new LinkedList<String>();

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void addInstanceOf(String className) {
            Reject.ifNull((Object)className);
            String value = className.trim();
            if (!value.matches(ClassPropertyDefinition.CLASS_RE)) {
                throw new IllegalArgumentException("\"" + value + "\" is not a valid Java class name");
            }
            this.instanceOfInterfaces.add(value);
        }

        @Override
        protected ClassPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
            return new ClassPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.instanceOfInterfaces);
        }
    }
}

