/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.ConfigurationFramework;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class AttributeTypePropertyDefinition
extends PropertyDefinition<AttributeType> {
    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private AttributeTypePropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<AttributeType> defaultBehavior) {
        super(d, AttributeType.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitAttributeType(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, AttributeType value, P p) {
        return v.visitAttributeType(this, value, p);
    }

    @Override
    public int compare(AttributeType o1, AttributeType o2) {
        return o1.getNameOrOID().compareToIgnoreCase(o2.getNameOrOID());
    }

    @Override
    public AttributeType decodeValue(String value) {
        Reject.ifNull((Object)value);
        String name = value.trim();
        if (!ConfigurationFramework.getInstance().isClient() && !Schema.getDefaultSchema().hasAttributeType(name)) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        AttributeType type = Schema.getDefaultSchema().asNonStrictSchema().getAttributeType(name);
        try {
            this.validateValue(type);
            return type;
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public String encodeValue(AttributeType value) {
        return value.getNameOrOID();
    }

    @Override
    public void validateValue(AttributeType value) {
        Reject.ifNull((Object)value);
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<AttributeType, AttributeTypePropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected AttributeTypePropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<AttributeType> defaultBehavior) {
            return new AttributeTypePropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

