/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Locale;
import java.util.MissingResourceException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;

public final class AdministratorAction {
    private final AbstractManagedObjectDefinition<?, ?> definition;
    private final String propertyName;
    private final Type type;

    public AdministratorAction(Type type, AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        this.type = type;
        this.definition = d;
        this.propertyName = propertyName;
    }

    public final LocalizableMessage getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final LocalizableMessage getSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.propertyName + ".requires-admin-action.synopsis";
        try {
            return resource.getMessage(this.definition, property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final Type getType() {
        return this.type;
    }

    public static enum Type {
        COMPONENT_RESTART("component-restart"),
        NONE("none"),
        OTHER("other"),
        SERVER_RESTART("server-restart");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

