/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.rest2ldap.authz.AbstractAsynchronousConnectionDecorator;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CachedReadConnectionDecorator
extends AbstractAsynchronousConnectionDecorator {
    private static final Logger logger = LoggerFactory.getLogger(CachedReadConnectionDecorator.class);
    private static final ResultHandler<Response> RESPONSE_LOGGER = new ResultHandler<Response>(){

        public void handleResult(Response response) {
            CachedReadConnectionDecorator.traceLog(response);
        }
    };
    private final Map<DN, CachedRead> cachedReads = new LinkedHashMap<DN, CachedRead>(){
        private static final int MAX_CACHED_ENTRIES = 32;

        @Override
        protected boolean removeEldestEntry(Map.Entry<DN, CachedRead> eldest) {
            return this.size() > 32;
        }
    };

    private static void traceLog(Object o) {
        if (logger.isTraceEnabled()) {
            logger.trace(o.toString());
        }
    }

    CachedReadConnectionDecorator(Connection delegate) {
        super(delegate);
    }

    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        CachedReadConnectionDecorator.traceLog(request);
        this.evictAll();
        return this.delegate.bindAsync(request, intermediateResponseHandler).thenOnResult(RESPONSE_LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictAll() {
        Map<DN, CachedRead> map = this.cachedReads;
        synchronized (map) {
            this.cachedReads.clear();
        }
    }

    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
        CachedReadConnectionDecorator.traceLog(request);
        this.evictAll();
        return this.delegate.extendedRequestAsync(request, intermediateResponseHandler).thenOnResult(RESPONSE_LOGGER);
    }

    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        CachedReadConnectionDecorator.traceLog(request);
        this.evict(request.getName());
        return this.delegate.modifyAsync(request, intermediateResponseHandler).thenOnResult(RESPONSE_LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict(DN name) {
        Map<DN, CachedRead> map = this.cachedReads;
        synchronized (map) {
            this.cachedReads.remove(name);
        }
    }

    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        CachedReadConnectionDecorator.traceLog(request);
        if (request.containsControl("1.2.840.113556.1.4.805")) {
            this.evictAll();
        } else {
            this.evict(request.getName());
        }
        return this.delegate.deleteAsync(request, intermediateResponseHandler).thenOnResult(RESPONSE_LOGGER);
    }

    @Override
    public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        CachedReadConnectionDecorator.traceLog(request);
        this.evictAll();
        return this.delegate.modifyDNAsync(request, intermediateResponseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
        CachedRead cachedRead;
        CachedReadConnectionDecorator.traceLog(request);
        if (!request.getScope().equals((Object)SearchScope.BASE_OBJECT) || intermediateResponseHandler != null) {
            return this.delegate.searchAsync(request, intermediateResponseHandler, entryHandler).thenOnResult(RESPONSE_LOGGER);
        }
        Map<DN, CachedRead> map = this.cachedReads;
        synchronized (map) {
            cachedRead = this.cachedReads.get(request.getName());
        }
        if (cachedRead != null && cachedRead.isMatchingRead(request)) {
            cachedRead.addResultHandler(entryHandler);
            return cachedRead.getPromise();
        }
        CachedRead pendingCachedRead = new CachedRead(request, entryHandler);
        Map<DN, CachedRead> map2 = this.cachedReads;
        synchronized (map2) {
            this.cachedReads.put(request.getName(), pendingCachedRead);
        }
        LdapPromise promise = this.delegate.searchAsync(request, intermediateResponseHandler, (SearchResultHandler)pendingCachedRead).thenOnResult((ResultHandler)pendingCachedRead).thenOnException((ExceptionHandler)pendingCachedRead);
        pendingCachedRead.setPromise((LdapPromise<Result>)promise);
        return promise.thenOnResult(RESPONSE_LOGGER);
    }

    private static final class CachedRead
    implements SearchResultHandler,
    LdapResultHandler<Result> {
        private SearchResultEntry cachedEntry;
        private final String cachedFilterString;
        private LdapPromise<Result> cachedPromise;
        private final CountDownLatch cachedPromiseLatch = new CountDownLatch(1);
        private final SearchRequest cachedRequest;
        private volatile Result cachedResult;
        private final ConcurrentLinkedQueue<SearchResultHandler> waitingResultHandlers = new ConcurrentLinkedQueue();

        CachedRead(SearchRequest request, SearchResultHandler resultHandler) {
            this.cachedRequest = request;
            this.cachedFilterString = request.getFilter().toString();
            this.waitingResultHandlers.add(resultHandler);
        }

        public boolean handleEntry(SearchResultEntry entry) {
            this.cachedEntry = entry;
            return true;
        }

        public void handleException(LdapException exception) {
            this.handleResult(exception.getResult());
        }

        public boolean handleReference(SearchResultReference reference) {
            return true;
        }

        public void handleResult(Result result) {
            this.cachedResult = result;
            this.drainQueue();
        }

        void addResultHandler(SearchResultHandler resultHandler) {
            if (this.cachedResult != null) {
                this.invokeResultHandler(resultHandler);
                return;
            }
            this.waitingResultHandlers.add(resultHandler);
            if (this.cachedResult != null) {
                this.drainQueue();
            }
        }

        LdapPromise<Result> getPromise() {
            boolean wasInterrupted = false;
            while (true) {
                try {
                    this.cachedPromiseLatch.await();
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return this.cachedPromise;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                    continue;
                }
                break;
            }
        }

        boolean isMatchingRead(SearchRequest request) {
            return request.getScope().equals((Object)SearchScope.BASE_OBJECT) && request.getFilter().toString().equals(this.cachedFilterString) && request.getAttributes().equals(this.cachedRequest.getAttributes());
        }

        void setPromise(LdapPromise<Result> promise) {
            this.cachedPromise = promise;
            this.cachedPromiseLatch.countDown();
        }

        private void drainQueue() {
            SearchResultHandler resultHandler;
            while ((resultHandler = this.waitingResultHandlers.poll()) != null) {
                this.invokeResultHandler(resultHandler);
            }
        }

        private void invokeResultHandler(SearchResultHandler searchResultHandler) {
            if (this.cachedEntry != null) {
                searchResultHandler.handleEntry(this.cachedEntry);
            }
        }
    }
}

