/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.Promise;

public abstract class AbstractRequestHandler
implements RequestHandler,
Describable<ApiDescription, Request> {
    protected AbstractRequestHandler() {
    }

    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.handleRequest(context, (Request)request);
    }

    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        return this.handleRequest(context, (Request)request);
    }

    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return this.handleRequest(context, (Request)request);
    }

    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return this.handleRequest(context, (Request)request);
    }

    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        return this.handleRequest(context, (Request)request);
    }

    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return this.handleRequest(context, (Request)request);
    }

    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return this.handleRequest(context, (Request)request);
    }

    protected <V> Promise<V, ResourceException> handleRequest(Context context, Request request) {
        return new NotSupportedException().asPromise();
    }

    public ApiDescription api(ApiProducer<ApiDescription> producer) {
        return null;
    }

    public ApiDescription handleApiRequest(Context context, Request request) {
        throw new UnsupportedOperationException("This should be handled by org.forgerock.opendj.rest2ldap.DescribableRequestHandler.handleApiRequest()");
    }

    public void addDescriptorListener(Describable.Listener listener) {
    }

    public void removeDescriptorListener(Describable.Listener listener) {
    }
}

