/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class OtherMailboxSyntaxImpl
extends AbstractSyntaxImpl {
    OtherMailboxSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.11";
    }

    @Override
    public String getName() {
        return "OtherMailbox";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.12";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        char c;
        int pos;
        if (value == null) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_EMPTY_VALUE.get());
            return false;
        }
        String valueString = value.toString();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_EMPTY_VALUE.get());
            return false;
        }
        for (pos = 0; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                if (pos == 0) {
                    invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MBTYPE.get((Object)valueString));
                    return false;
                }
                ++pos;
                break;
            }
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) continue;
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MBTYPE_CHAR.get((Object)valueString, (Object)String.valueOf(c), (Object)pos));
            return false;
        }
        if (pos >= valueLength) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MAILBOX.get((Object)valueString));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (c != (c & 0x7F)) {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MB_CHAR.get((Object)valueString, (Object)String.valueOf(c), (Object)pos));
                return false;
            }
            ++pos;
        }
        return true;
    }
}

