/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;

final class GenerateCoreSchema {
    private static final Set<String> ABBREVIATIONS = new HashSet<String>(Arrays.asList("SASL", "LDAP", "DN", "DIT", "RDN", "JPEG", "OID", "UUID", "IA5", "UID", "UTC", "X500", "X121", "C", "CN", "O", "OU", "L", "DC", "ISDN", "SN", "ST"));

    public static void main(String[] args) {
        String description;
        GenerateCoreSchema.testSplitNameIntoWords();
        Schema schema = Schema.getCoreSchema();
        TreeMap<String, Syntax> syntaxes = new TreeMap<String, Syntax>();
        for (Syntax syntax : schema.getSyntaxes()) {
            if (GenerateCoreSchema.isOpenDSOID(syntax.getOID())) continue;
            String string = syntax.getDescription().replaceAll(" Syntax$", "");
            String string2 = string.replace(" ", "_").replaceAll("[.-]", "").toUpperCase(Locale.ENGLISH).concat("_SYNTAX");
            syntaxes.put(string2, syntax);
        }
        TreeMap<String, MatchingRule> matchingRules = new TreeMap<String, MatchingRule>();
        for (MatchingRule matchingRule : schema.getMatchingRules()) {
            if (GenerateCoreSchema.isOpenDSOID(matchingRule.getOID()) || GenerateCoreSchema.isCollationMatchingRule(matchingRule.getOID())) continue;
            String string = matchingRule.getNameOrOID().replaceAll("Match$", "");
            String fieldName = GenerateCoreSchema.splitNameIntoWords(string).concat("_MATCHING_RULE");
            matchingRules.put(fieldName, matchingRule);
        }
        TreeMap<String, AttributeType> treeMap = new TreeMap<String, AttributeType>();
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            if (GenerateCoreSchema.isOpenDSOID(attributeType.getOID())) continue;
            String name = attributeType.getNameOrOID();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name).concat("_ATTRIBUTE_TYPE");
            treeMap.put(fieldName, attributeType);
        }
        TreeMap<String, ObjectClass> treeMap2 = new TreeMap<String, ObjectClass>();
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            if (GenerateCoreSchema.isOpenDSOID(objectClass.getOID())) continue;
            String name = objectClass.getNameOrOID();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name.replace("-", "")).concat("_OBJECT_CLASS");
            treeMap2.put(fieldName, objectClass);
        }
        PrintStream printStream = System.out;
        printStream.println("/*");
        printStream.println(" * The contents of this file are subject to the terms of the Common Development and");
        printStream.println(" * Distribution License (the License). You may not use this file except in compliance with the");
        printStream.println(" * License.");
        printStream.println(" *");
        printStream.println(" * You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the");
        printStream.println(" * specific language governing permission and limitations under the License.");
        printStream.println(" *");
        printStream.println(" * When distributing Covered Software, include this CDDL Header Notice in each file and include");
        printStream.println(" * the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL");
        printStream.println(" * Header, with the fields enclosed by brackets [] replaced by your own identifying");
        printStream.println(" * information: \"Portions Copyright [year] [name of copyright owner]\".");
        printStream.println(" *");
        printStream.println(" * Copyright 2009 Sun Microsystems, Inc.");
        printStream.println(" * Portions copyright 2014-" + Calendar.getInstance().get(1) + " ForgeRock AS.");
        printStream.println(" */");
        printStream.println("package org.forgerock.opendj.ldap.schema;");
        printStream.println();
        printStream.println();
        printStream.println("// DON'T EDIT THIS FILE!");
        printStream.println("// It is automatically generated using GenerateCoreSchema class.");
        printStream.println();
        printStream.println("/**");
        printStream.println(" * The OpenDJ SDK core schema contains standard LDAP RFC schema elements. These include:");
        printStream.println(" * <ul>");
        printStream.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4512\">RFC 4512 -");
        printStream.println(" * Lightweight Directory Access Protocol (LDAP): Directory Information");
        printStream.println(" * Models </a>");
        printStream.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4517\">RFC 4517 -");
        printStream.println(" * Lightweight Directory Access Protocol (LDAP): Syntaxes and Matching");
        printStream.println(" * Rules </a>");
        printStream.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4519\">RFC 4519 -");
        printStream.println(" * Lightweight Directory Access Protocol (LDAP): Schema for User");
        printStream.println(" * Applications </a>");
        printStream.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4530\">RFC 4530 -");
        printStream.println(" * Lightweight Directory Access Protocol (LDAP): entryUUID Operational");
        printStream.println(" * Attribute </a>");
        printStream.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3045\">RFC 3045 - Storing");
        printStream.println(" * Vendor Information in the LDAP Root DSE </a>");
        printStream.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3112\">RFC 3112 - LDAP");
        printStream.println(" * Authentication Password Schema </a>");
        printStream.println(" * </ul>");
        printStream.println(" * <p>");
        printStream.println(" * The core schema is non-strict: attempts to retrieve");
        printStream.println(" * non-existent Attribute Types will return a temporary");
        printStream.println(" * Attribute Type having the Octet String syntax.");
        printStream.println(" */");
        printStream.println("public final class CoreSchema {");
        printStream.println("    // Core Syntaxes");
        for (Map.Entry syntax : syntaxes.entrySet()) {
            printStream.println("    private static final Syntax " + (String)syntax.getKey() + " =");
            printStream.println("        CoreSchemaImpl.getInstance().getSyntax(\"" + ((Syntax)syntax.getValue()).getOID() + "\");");
        }
        printStream.println();
        printStream.println("    // Core Matching Rules");
        for (Map.Entry matchingRule : matchingRules.entrySet()) {
            printStream.println("    private static final MatchingRule " + (String)matchingRule.getKey() + " =");
            printStream.println("        CoreSchemaImpl.getInstance().getMatchingRule(\"" + ((MatchingRule)matchingRule.getValue()).getOID() + "\");");
        }
        printStream.println();
        printStream.println("    // Core Attribute Types");
        for (Map.Entry attributeType : treeMap.entrySet()) {
            printStream.println("    private static final AttributeType " + (String)attributeType.getKey() + " =");
            printStream.println("        CoreSchemaImpl.getInstance().getAttributeType(\"" + ((AttributeType)attributeType.getValue()).getOID() + "\");");
        }
        printStream.println();
        printStream.println("    // Core Object Classes");
        for (Map.Entry objectClass : treeMap2.entrySet()) {
            printStream.println("    private static final ObjectClass " + (String)objectClass.getKey() + " =");
            printStream.println("        CoreSchemaImpl.getInstance().getObjectClass(\"" + ((ObjectClass)objectClass.getValue()).getOID() + "\");");
        }
        printStream.println();
        printStream.println("    // Prevent instantiation");
        printStream.println("    private CoreSchema() {");
        printStream.println("      // Nothing to do.");
        printStream.println("    }");
        printStream.println();
        printStream.println("    /**");
        printStream.println("     * Returns a reference to the singleton core schema.");
        printStream.println("     *");
        printStream.println("     * @return The core schema.");
        printStream.println("     */");
        printStream.println("    public static Schema getInstance() {");
        printStream.println("        return CoreSchemaImpl.getInstance();");
        printStream.println("    }");
        for (Map.Entry syntax : syntaxes.entrySet()) {
            printStream.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((Syntax)syntax.getValue()).getDescription().replaceAll(" Syntax$", "") + " Syntax");
            printStream.println("    /**");
            printStream.println("     * Returns a reference to the " + description);
            printStream.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((Syntax)syntax.getValue()).getOID()) + ".");
            printStream.println("     *");
            printStream.println("     * @return A reference to the " + description + ".");
            printStream.println("     */");
            printStream.println("    public static Syntax get" + GenerateCoreSchema.toJavaName((String)syntax.getKey()) + "() {");
            printStream.println("        return " + (String)syntax.getKey() + ";");
            printStream.println("    }");
        }
        for (Map.Entry matchingRule : matchingRules.entrySet()) {
            printStream.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)matchingRule.getValue()).getNameOrOID());
            printStream.println("    /**");
            printStream.println("     * Returns a reference to the " + description + " Matching Rule");
            printStream.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)matchingRule.getValue()).getOID()) + ".");
            printStream.println("     *");
            printStream.println("     * @return A reference to the " + description + " Matching Rule.");
            printStream.println("     */");
            printStream.println("    public static MatchingRule get" + GenerateCoreSchema.toJavaName((String)matchingRule.getKey()) + "() {");
            printStream.println("        return " + (String)matchingRule.getKey() + ";");
            printStream.println("    }");
        }
        for (Map.Entry attributeType : treeMap.entrySet()) {
            printStream.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((AttributeType)attributeType.getValue()).getNameOrOID());
            printStream.println("    /**");
            printStream.println("     * Returns a reference to the " + description + " Attribute Type");
            printStream.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((AttributeType)attributeType.getValue()).getOID()) + ".");
            printStream.println("     *");
            printStream.println("     * @return A reference to the " + description + " Attribute Type.");
            printStream.println("     */");
            printStream.println("    public static AttributeType get" + GenerateCoreSchema.toJavaName((String)attributeType.getKey()) + "() {");
            printStream.println("        return " + (String)attributeType.getKey() + ";");
            printStream.println("    }");
        }
        for (Map.Entry objectClass : treeMap2.entrySet()) {
            printStream.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)objectClass.getValue()).getNameOrOID());
            printStream.println("    /**");
            printStream.println("     * Returns a reference to the " + description + " Object Class");
            printStream.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)objectClass.getValue()).getOID()) + ".");
            printStream.println("     *");
            printStream.println("     * @return A reference to the " + description + " Object Class.");
            printStream.println("     */");
            printStream.println("    public static ObjectClass get" + GenerateCoreSchema.toJavaName((String)objectClass.getKey()) + "() {");
            printStream.println("        return " + (String)objectClass.getKey() + ";");
            printStream.println("    }");
        }
        printStream.println("}");
    }

    private static boolean isOpenDSOID(String oid) {
        return oid.startsWith("1.3.6.1.4.1.26027.1.");
    }

    private static boolean isCollationMatchingRule(String oid) {
        return oid.startsWith("1.3.6.1.4.1.42.2.27.9.4.");
    }

    private static String splitNameIntoWords(String name) {
        String splitName = name.replaceAll("([A-Z][a-z])", "_$1");
        splitName = splitName.replaceAll("([a-z])([A-Z])", "$1_$2");
        splitName = splitName.replaceAll("[-.]", "");
        return splitName.toUpperCase(Locale.ENGLISH);
    }

    private static void testSplitNameIntoWords() {
        String[][] values;
        for (String[] test : values = new String[][]{{"oneTwoThree", "ONE_TWO_THREE"}, {"oneTWOThree", "ONE_TWO_THREE"}, {"oneX500Three", "ONE_X500_THREE"}, {"oneTwoX500", "ONE_TWO_X500"}, {"oneTwoX500", "ONE_TWO_X500"}, {"x500TwoThree", "X500_TWO_THREE"}}) {
            String expected;
            String actual = GenerateCoreSchema.splitNameIntoWords(test[0]);
            if (actual.equals(expected = test[1])) continue;
            System.out.println("Test Split Failure: " + test[0] + " -> " + actual + " != " + expected);
        }
    }

    private static String toCodeJavaDoc(String text) {
        return String.format("{@code %s}", text);
    }

    private static String toJavaName(String splitName) {
        StringBuilder builder = new StringBuilder();
        for (String word : splitName.split("_")) {
            if (ABBREVIATIONS.contains(word)) {
                builder.append(word);
                continue;
            }
            builder.append(word.charAt(0));
            if (word.length() <= 1) continue;
            builder.append(word.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    private GenerateCoreSchema() {
    }
}

