/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.PersistentSearchChangeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class EntryChangeNotificationResponseControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "2.16.840.1.113730.3.4.7";
    public static final ControlDecoder<EntryChangeNotificationResponseControl> DECODER = new ControlDecoder<EntryChangeNotificationResponseControl>(){

        @Override
        public EntryChangeNotificationResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            PersistentSearchChangeType changeType;
            Reject.ifNull((Object[])new Object[]{control, options});
            if (control instanceof EntryChangeNotificationResponseControl) {
                return (EntryChangeNotificationResponseControl)control;
            }
            if (!control.getOID().equals(EntryChangeNotificationResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_ECN_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)EntryChangeNotificationResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_ECN_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            String previousDNString = null;
            long changeNumber = -1L;
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                int changeTypeInt = reader.readEnumerated();
                switch (changeTypeInt) {
                    case 1: {
                        changeType = PersistentSearchChangeType.ADD;
                        break;
                    }
                    case 2: {
                        changeType = PersistentSearchChangeType.DELETE;
                        break;
                    }
                    case 4: {
                        changeType = PersistentSearchChangeType.MODIFY;
                        break;
                    }
                    case 8: {
                        changeType = PersistentSearchChangeType.MODIFY_DN;
                        break;
                    }
                    default: {
                        LocalizableMessage message = CoreMessages.ERR_ECN_BAD_CHANGE_TYPE.get((Object)changeTypeInt);
                        throw DecodeException.error(message);
                    }
                }
                if (reader.hasNextElement() && reader.peekType() == 4) {
                    if (changeType != PersistentSearchChangeType.MODIFY_DN) {
                        LocalizableMessage message = CoreMessages.ERR_ECN_ILLEGAL_PREVIOUS_DN.get((Object)String.valueOf((Object)changeType));
                        throw DecodeException.error(message);
                    }
                    previousDNString = reader.readOctetStringAsString();
                }
                if (reader.hasNextElement() && reader.peekType() == 2) {
                    changeNumber = reader.readInteger();
                }
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{e}));
                LocalizableMessage message = CoreMessages.ERR_ECN_CANNOT_DECODE_VALUE.get((Object)StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
            Schema schema = options.getSchemaResolver().resolveSchema(previousDNString);
            DN previousDN = null;
            if (previousDNString != null) {
                try {
                    previousDN = DN.valueOf(previousDNString, schema);
                }
                catch (LocalizedIllegalArgumentException e) {
                    LocalizableMessage message = CoreMessages.ERR_ECN_INVALID_PREVIOUS_DN.get((Object)StaticUtils.getExceptionMessage(e));
                    throw DecodeException.error(message, e);
                }
            }
            return new EntryChangeNotificationResponseControl(control.isCritical(), changeType, previousDN, changeNumber);
        }

        @Override
        public String getOID() {
            return EntryChangeNotificationResponseControl.OID;
        }
    };
    private final DN previousName;
    private final long changeNumber;
    private final PersistentSearchChangeType changeType;
    private final boolean isCritical;

    public static EntryChangeNotificationResponseControl newControl(PersistentSearchChangeType type, DN previousName, long changeNumber) {
        return new EntryChangeNotificationResponseControl(false, type, previousName, changeNumber);
    }

    public static EntryChangeNotificationResponseControl newControl(PersistentSearchChangeType type, String previousName, long changeNumber) {
        return new EntryChangeNotificationResponseControl(false, type, DN.valueOf(previousName), changeNumber);
    }

    private EntryChangeNotificationResponseControl(boolean isCritical, PersistentSearchChangeType changeType, DN previousName, long changeNumber) {
        Reject.ifNull((Object)((Object)changeType));
        this.isCritical = isCritical;
        this.changeType = changeType;
        this.previousName = previousName;
        this.changeNumber = changeNumber;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public PersistentSearchChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public String getOID() {
        return OID;
    }

    public DN getPreviousName() {
        return this.previousName;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.changeType.intValue());
            if (this.previousName != null) {
                writer.writeOctetString(this.previousName.toString());
            }
            if (this.changeNumber > 0L) {
                writer.writeInteger(this.changeNumber);
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EntryChangeNotificationResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", changeType=");
        builder.append((Object)this.changeType);
        builder.append(", previousDN=\"");
        builder.append(this.previousName);
        builder.append("\"");
        builder.append(", changeNumber=");
        builder.append(this.changeNumber);
        builder.append(")");
        return builder.toString();
    }
}

