/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.promise.NeverThrowsException;

public final class ConsistentHashMap<P> {
    private static final int DEFAULT_WEIGHT = 200;
    @VisibleForTesting
    static final Function<Object, Integer, NeverThrowsException> MD5 = new Function<Object, Integer, NeverThrowsException>(){

        public Integer apply(Object key) {
            byte[] bytes = key.toString().getBytes(StandardCharsets.UTF_8);
            byte[] digest = this.getMD5Digest().digest(bytes);
            return ByteString.wrap(digest).toInt();
        }

        private MessageDigest getMD5Digest() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final ReentrantLock writeLock = new ReentrantLock();
    private volatile NavigableMap<Integer, Node<P>> circle = new TreeMap<Integer, Node<P>>();
    private volatile Map<String, P> partitions = new LinkedHashMap<String, P>();
    private final Function<Object, Integer, NeverThrowsException> hashFunction;

    public ConsistentHashMap() {
        this(MD5);
    }

    public ConsistentHashMap(Function<Object, Integer, NeverThrowsException> hashFunction) {
        this.hashFunction = hashFunction;
    }

    public ConsistentHashMap<P> put(String partitionId, P partition) {
        return this.put(partitionId, partition, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsistentHashMap<P> put(String partitionId, P partition, int weight) {
        Reject.ifNull((Object)partitionId, (String)"partitionId must be non-null");
        Reject.ifNull(partition, (String)"partition must be non-null");
        Reject.ifTrue((weight < 0 ? 1 : 0) != 0, (String)"Weight must be a positive integer");
        Node node = new Node(partitionId, partition, weight);
        this.writeLock.lock();
        try {
            TreeMap<Integer, Node<P>> newCircle = new TreeMap<Integer, Node<P>>(this.circle);
            for (int i = 0; i < weight; ++i) {
                newCircle.put((Integer)this.hashFunction.apply((Object)(partitionId + i)), node);
            }
            LinkedHashMap<String, P> newPartitions = new LinkedHashMap<String, P>(this.partitions);
            newPartitions.put(partitionId, partition);
            this.circle = newCircle;
            this.partitions = newPartitions;
        }
        finally {
            this.writeLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsistentHashMap<P> remove(String partitionId) {
        Reject.ifNull((Object)partitionId, (String)"partitionId must be non-null");
        this.writeLock.lock();
        try {
            if (this.partitions.containsKey(partitionId)) {
                TreeMap<Integer, Node<P>> newCircle = new TreeMap<Integer, Node<P>>(this.circle);
                Node<P> node = newCircle.remove(this.hashFunction.apply((Object)(partitionId + 0)));
                for (int i = 1; i < ((Node)node).weight; ++i) {
                    newCircle.remove(this.hashFunction.apply((Object)(partitionId + i)));
                }
                LinkedHashMap<String, P> newPartitions = new LinkedHashMap<String, P>(this.partitions);
                newPartitions.remove(partitionId);
                this.circle = newCircle;
                this.partitions = newPartitions;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return this;
    }

    P get(Object key) {
        NavigableMap<Integer, Node<P>> circleSnapshot = this.circle;
        Map.Entry<Integer, Node<P>> ceilingEntry = circleSnapshot.ceilingEntry((Integer)this.hashFunction.apply(key));
        if (ceilingEntry != null) {
            return (P)((Node)ceilingEntry.getValue()).partition;
        }
        Map.Entry<Integer, Node<P>> firstEntry = circleSnapshot.firstEntry();
        return (P)(firstEntry != null ? ((Node)firstEntry.getValue()).partition : null);
    }

    Collection<P> getAll() {
        return this.partitions.values();
    }

    int size() {
        return this.partitions.size();
    }

    boolean isEmpty() {
        return this.partitions.isEmpty();
    }

    @VisibleForTesting
    Map<P, Long> getWeights() {
        NavigableMap<Integer, Node<P>> circleSnapshot = this.circle;
        IdentityHashMap<Object, Long> weights = new IdentityHashMap<Object, Long>();
        Map.Entry previousEntry = null;
        for (Map.Entry entry : circleSnapshot.entrySet()) {
            long index = ((Integer)entry.getKey()).intValue();
            Object partition = ((Node)entry.getValue()).partition;
            if (previousEntry == null) {
                long range1 = Integer.MAX_VALUE - (long)circleSnapshot.lastEntry().getKey().intValue();
                long range2 = index - Integer.MIN_VALUE;
                weights.put(partition, range1 + range2 + 1L);
            } else {
                long start = ((Integer)previousEntry.getKey()).intValue();
                long end = ((Integer)entry.getKey()).intValue();
                if (weights.containsKey(partition)) {
                    weights.put(partition, (Long)weights.get(partition) + (end - start));
                } else {
                    weights.put(partition, end - start);
                }
            }
            previousEntry = entry;
        }
        return weights;
    }

    public String toString() {
        return this.getWeights().toString();
    }

    private static final class Node<P> {
        private final String partitionId;
        private final P partition;
        private final int weight;

        private Node(String partitionId, P partition, int weight) {
            this.partitionId = partitionId;
            this.partition = partition;
            this.weight = weight;
        }

        public String toString() {
            return this.partitionId;
        }
    }
}

