/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancer;
import org.forgerock.util.Options;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

abstract class ConnectionLoadBalancer
extends LoadBalancer {
    ConnectionLoadBalancer(String loadBalancerName, Collection<? extends ConnectionFactory> factories, Options options) {
        super(loadBalancerName, factories, options);
    }

    @Override
    public final Connection getConnection() throws LdapException {
        return this.getMonitoredConnectionFactory(this.getInitialConnectionFactoryIndex()).getConnection();
    }

    @Override
    public final Promise<Connection, LdapException> getConnectionAsync() {
        try {
            return this.getMonitoredConnectionFactory(this.getInitialConnectionFactoryIndex()).getConnectionAsync();
        }
        catch (LdapException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    abstract int getInitialConnectionFactoryIndex();
}

