/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.time.TimeService;

final class CachedConnectionPool
implements ConnectionPool {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    TimeService timeService = TimeService.SYSTEM;
    private final Semaphore availableConnections;
    private final ResultHandler<Connection> connectionResultHandler = new ConnectionResultHandler();
    private final ExceptionHandler<LdapException> connectionFailureHandler = new ConnectionFailureHandler();
    private final int corePoolSize;
    private final ConnectionFactory factory;
    private boolean isClosed;
    private final ScheduledFuture<?> idleTimeoutFuture;
    private final long idleTimeoutMillis;
    private final int maxPoolSize;
    private final LinkedList<QueueElement> queue = new LinkedList();
    private final ReferenceCountedObject.Reference scheduler;
    private final AtomicInteger pendingConnectionAttempts = new AtomicInteger();

    CachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit, ScheduledExecutorService scheduler) {
        Reject.ifNull((Object)factory);
        Reject.ifFalse((corePoolSize >= 0 ? 1 : 0) != 0, (String)"corePoolSize < 0");
        Reject.ifFalse((maximumPoolSize > 0 ? 1 : 0) != 0, (String)"maxPoolSize <= 0");
        Reject.ifFalse((corePoolSize <= maximumPoolSize ? 1 : 0) != 0, (String)"corePoolSize > maxPoolSize");
        Reject.ifFalse((idleTimeout >= 0L ? 1 : 0) != 0, (String)"idleTimeout < 0");
        Reject.ifFalse((idleTimeout == 0L || unit != null ? 1 : 0) != 0, (String)"time unit is null");
        this.factory = factory;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maximumPoolSize;
        this.availableConnections = new Semaphore(maximumPoolSize);
        if (corePoolSize < maximumPoolSize && idleTimeout > 0L) {
            this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull(scheduler);
            this.idleTimeoutMillis = unit.toMillis(idleTimeout);
            this.idleTimeoutFuture = ((ScheduledExecutorService)this.scheduler.get()).scheduleWithFixedDelay(new PurgeIdleConnectionsTask(), idleTimeout, idleTimeout, unit);
        } else {
            this.scheduler = null;
            this.idleTimeoutMillis = 0L;
            this.idleTimeoutFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList<Connection> idleConnections;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            idleConnections = new LinkedList<Connection>();
            while (this.hasWaitingConnections()) {
                QueueElement holder = this.queue.removeFirst();
                idleConnections.add(holder.getWaitingConnection());
                this.availableConnections.release();
            }
        }
        logger.debug(LocalizableMessage.raw((CharSequence)"Connection pool is closing: availableConnections=%d, maxPoolSize=%d", (Object[])new Object[]{this.currentPoolSize(), this.maxPoolSize}));
        if (this.idleTimeoutFuture != null) {
            this.idleTimeoutFuture.cancel(false);
            this.scheduler.release();
        }
        for (Connection connection : idleConnections) {
            connection.close();
        }
        this.factory.close();
    }

    @Override
    public Connection getConnection() throws LdapException {
        try {
            return (Connection)this.getConnectionAsync().getOrThrow();
        }
        catch (InterruptedException e) {
            throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        while (true) {
            QueueElement holder;
            LinkedList<QueueElement> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.isClosed) {
                    throw new IllegalStateException("CachedConnectionPool is already closed");
                }
                if (this.hasWaitingConnections()) {
                    holder = this.queue.removeFirst();
                } else {
                    holder = new QueueElement(this.timeService.now(), StaticUtils.getStackTraceIfDebugEnabled());
                    this.queue.add(holder);
                }
            }
            if (holder.isWaitingPromise()) {
                PromiseImpl<Connection, LdapException> promise = holder.getWaitingPromise();
                if (!promise.isDone() && this.availableConnections.tryAcquire()) {
                    this.pendingConnectionAttempts.incrementAndGet();
                    this.factory.getConnectionAsync().thenOnResult(this.connectionResultHandler).thenOnException(this.connectionFailureHandler);
                }
                return promise;
            }
            Connection connection = holder.getWaitingConnection();
            if (connection.isValid()) {
                PooledConnection pooledConnection = this.newPooledConnection(connection, StaticUtils.getStackTraceIfDebugEnabled());
                return Promises.newResultPromise((Object)pooledConnection);
            }
            connection.close();
            this.availableConnections.release();
            logger.debug(LocalizableMessage.raw((CharSequence)"Connection no longer valid: availableConnections=%d, poolSize=%d", (Object[])new Object[]{this.currentPoolSize(), this.maxPoolSize}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = this.currentPoolSize();
        int pending = this.pendingConnectionAttempts.get();
        int in = 0;
        int blocked = 0;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            for (QueueElement qe : this.queue) {
                if (qe.isWaitingPromise()) {
                    ++blocked;
                    continue;
                }
                ++in;
            }
        }
        int out = size - in - pending;
        return String.format("CachedConnectionPool(size=%d[in:%d + out:%d + pending:%d], maxSize=%d, blocked=%d, factory=%s)", size, in, out, pending, this.maxPoolSize, blocked, String.valueOf(this.factory));
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    int currentPoolSize() {
        return this.maxPoolSize - this.availableConnections.availablePermits();
    }

    private boolean hasWaitingConnections() {
        return !this.queue.isEmpty() && !this.queue.getFirst().isWaitingPromise();
    }

    private boolean hasWaitingPromises() {
        return !this.queue.isEmpty() && this.queue.getFirst().isWaitingPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishConnection(Connection connection) {
        QueueElement holder;
        boolean connectionPoolIsClosing = false;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.hasWaitingPromises()) {
                connectionPoolIsClosing = this.isClosed;
                holder = this.queue.removeFirst();
            } else if (this.isClosed) {
                connectionPoolIsClosing = true;
                holder = null;
            } else {
                QueueElement holder2 = new QueueElement(connection, this.timeService.now());
                this.queue.add(holder2);
                return;
            }
        }
        if (connectionPoolIsClosing) {
            this.availableConnections.release();
            connection.close();
            logger.debug(LocalizableMessage.raw((CharSequence)"Closing connection because connection pool is closing: availableConnections=%d, maxPoolSize=%d", (Object[])new Object[]{this.currentPoolSize(), this.maxPoolSize}));
            if (holder != null) {
                LdapException e = LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, CoreMessages.ERR_CONNECTION_POOL_CLOSING.get((Object)this.toString()).toString());
                holder.getWaitingPromise().handleException((Exception)e);
                logger.debug(LocalizableMessage.raw((CharSequence)"Connection attempt failed: availableConnections=%d, maxPoolSize=%d", (Object[])new Object[]{this.currentPoolSize(), this.maxPoolSize, e}));
            }
        } else {
            holder.getWaitingPromise().handleResult((Object)this.newPooledConnection(connection, holder.getStackTrace()));
        }
    }

    private PooledConnection newPooledConnection(Connection connection, StackTraceElement[] stack) {
        if (!StaticUtils.DEBUG_ENABLED) {
            return new PooledConnection(connection);
        }
        return new DebugEnabledPooledConnection(connection, stack);
    }

    private static final class QueueElement {
        private final long timestampMillis;
        private final Object value;
        private final StackTraceElement[] stack;

        QueueElement(Connection connection, long timestampMillis) {
            this.value = connection;
            this.timestampMillis = timestampMillis;
            this.stack = null;
        }

        QueueElement(long timestampMillis, StackTraceElement[] stack) {
            this.value = PromiseImpl.create();
            this.timestampMillis = timestampMillis;
            this.stack = stack;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        StackTraceElement[] getStackTrace() {
            return this.stack;
        }

        Connection getWaitingConnection() {
            if (this.value instanceof Connection) {
                return (Connection)this.value;
            }
            throw new IllegalStateException();
        }

        PromiseImpl<Connection, LdapException> getWaitingPromise() {
            return (PromiseImpl)this.value;
        }

        boolean hasTimedOut(long timeLimitMillis) {
            return this.timestampMillis < timeLimitMillis;
        }

        boolean isWaitingPromise() {
            return this.value instanceof PromiseImpl;
        }
    }

    private final class DebugEnabledPooledConnection
    extends PooledConnection {
        private final StackTraceElement[] stackTrace;

        private DebugEnabledPooledConnection(Connection connection, StackTraceElement[] stackTrace) {
            super(connection);
            this.stackTrace = stackTrace;
        }

        protected void finalize() throws Throwable {
            if (!this.isClosed()) {
                StaticUtils.logIfDebugEnabled("CONNECTION POOL: connection leaked! It was allocated here: ", this.stackTrace);
            }
        }
    }

    private final class PurgeIdleConnectionsTask
    implements Runnable {
        private PurgeIdleConnectionsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<Connection> idleConnections;
            LinkedList linkedList = CachedConnectionPool.this.queue;
            synchronized (linkedList) {
                if (CachedConnectionPool.this.isClosed) {
                    return;
                }
                idleConnections = new LinkedList<Connection>();
                long timeoutMillis = CachedConnectionPool.this.timeService.now() - CachedConnectionPool.this.idleTimeoutMillis;
                QueueElement holder = (QueueElement)CachedConnectionPool.this.queue.peek();
                for (int nonCoreConnectionCount = CachedConnectionPool.this.currentPoolSize() - CachedConnectionPool.this.corePoolSize; nonCoreConnectionCount > 0 && this.isTimedOutQueuedConnection(holder, timeoutMillis); --nonCoreConnectionCount) {
                    idleConnections.add(holder.getWaitingConnection());
                    CachedConnectionPool.this.queue.poll();
                    CachedConnectionPool.this.availableConnections.release();
                    holder = (QueueElement)CachedConnectionPool.this.queue.peek();
                }
            }
            if (!idleConnections.isEmpty()) {
                logger.debug(LocalizableMessage.raw((CharSequence)"Closing %d idle pooled connections: availableConnections=%d, maxPoolSize=%d", (Object[])new Object[]{idleConnections.size(), CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize}));
                for (Connection connection : idleConnections) {
                    connection.close();
                }
            }
        }

        private boolean isTimedOutQueuedConnection(QueueElement holder, long timeoutMillis) {
            return holder != null && !holder.isWaitingPromise() && holder.hasTimedOut(timeoutMillis);
        }
    }

    class PooledConnection
    implements Connection,
    ConnectionEventListener {
        private final Connection connection;
        private LdapException error;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private boolean isDisconnectNotification;
        private List<ConnectionEventListener> listeners;
        private final Object stateLock = new Object();

        PooledConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return this.checkState().abandonAsync(request);
        }

        @Override
        public Result add(AddRequest request) throws LdapException {
            return this.checkState().add(request);
        }

        @Override
        public Result add(Entry entry) throws LdapException {
            return this.checkState().add(entry);
        }

        @Override
        public Result add(String ... ldifLines) throws LdapException {
            return this.checkState().add(ldifLines);
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request) {
            return this.addAsync(request, null);
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().addAsync(request, intermediateResponseHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            boolean notifyErrorOccurred;
            boolean notifyClose;
            Reject.ifNull((Object)listener);
            Object object = this.stateLock;
            synchronized (object) {
                notifyClose = this.isClosed.get();
                boolean bl = notifyErrorOccurred = this.error != null;
                if (!notifyClose) {
                    if (this.listeners == null) {
                        this.listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
                        this.listeners.add(listener);
                        this.connection.addConnectionEventListener(this);
                    } else {
                        this.listeners.add(listener);
                    }
                }
            }
            if (notifyErrorOccurred) {
                listener.handleConnectionError(this.isDisconnectNotification, this.error);
            }
            if (notifyClose) {
                listener.handleConnectionClosed();
            }
        }

        @Override
        public Result applyChange(ChangeRecord request) throws LdapException {
            return this.checkState().applyChange(request);
        }

        @Override
        public LdapPromise<Result> applyChangeAsync(ChangeRecord request) {
            return this.checkState().applyChangeAsync(request, null);
        }

        @Override
        public LdapPromise<Result> applyChangeAsync(ChangeRecord request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().applyChangeAsync(request, intermediateResponseHandler);
        }

        @Override
        public BindResult bind(BindRequest request) throws LdapException {
            return this.checkState().bind(request);
        }

        @Override
        public BindResult bind(String name, char[] password) throws LdapException {
            return this.checkState().bind(name, password);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(BindRequest request) {
            return this.bindAsync(request, null);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().bindAsync(request, intermediateResponseHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<ConnectionEventListener> tmpListeners;
            Iterator<ConnectionEventListener> iterator = this.stateLock;
            synchronized (iterator) {
                if (!this.isClosed.compareAndSet(false, true)) {
                    return;
                }
                tmpListeners = this.listeners;
            }
            if (tmpListeners != null) {
                this.connection.removeConnectionEventListener(this);
            }
            if (this.connection.isValid()) {
                CachedConnectionPool.this.publishConnection(this.connection);
            } else {
                this.connection.close();
                CachedConnectionPool.this.pendingConnectionAttempts.incrementAndGet();
                CachedConnectionPool.this.factory.getConnectionAsync().thenOnResult(CachedConnectionPool.this.connectionResultHandler).thenOnException(CachedConnectionPool.this.connectionFailureHandler);
                logger.debug(LocalizableMessage.raw((CharSequence)"Connection no longer valid: availableConnections=%d, maxPoolSize=%d", (Object[])new Object[]{CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize}));
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionClosed();
                }
            }
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.close();
        }

        @Override
        public CompareResult compare(CompareRequest request) throws LdapException {
            return this.checkState().compare(request);
        }

        @Override
        public CompareResult compare(String name, String attributeDescription, String assertionValue) throws LdapException {
            return this.checkState().compare(name, attributeDescription, assertionValue);
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request) {
            return this.compareAsync(request, null);
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().compareAsync(request, intermediateResponseHandler);
        }

        @Override
        public Result delete(DeleteRequest request) throws LdapException {
            return this.checkState().delete(request);
        }

        @Override
        public Result delete(String name) throws LdapException {
            return this.checkState().delete(name);
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request) {
            return this.deleteAsync(request, null);
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().deleteAsync(request, intermediateResponseHandler);
        }

        @Override
        public Result deleteSubtree(String name) throws LdapException {
            return this.checkState().deleteSubtree(name);
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws LdapException {
            return this.checkState().extendedRequest(request);
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws LdapException {
            return this.checkState().extendedRequest(request, handler);
        }

        @Override
        public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws LdapException {
            return this.checkState().extendedRequest(requestName, requestValue);
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request) {
            return this.extendedRequestAsync(request, null);
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().extendedRequestAsync(request, intermediateResponseHandler);
        }

        @Override
        public void handleConnectionClosed() {
            throw new IllegalStateException("Pooled connection received unexpected close notification");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleConnectionError(boolean isDisconnectNotification, LdapException error) {
            List<ConnectionEventListener> tmpListeners;
            Iterator<ConnectionEventListener> iterator = this.stateLock;
            synchronized (iterator) {
                tmpListeners = this.listeners;
                this.isDisconnectNotification = isDisconnectNotification;
                this.error = error;
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionError(isDisconnectNotification, error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            List<ConnectionEventListener> tmpListeners;
            Iterator<ConnectionEventListener> iterator = this.stateLock;
            synchronized (iterator) {
                tmpListeners = this.listeners;
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleUnsolicitedNotification(notification);
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.isClosed.get();
        }

        @Override
        public boolean isValid() {
            return this.connection.isValid() && !this.isClosed();
        }

        @Override
        public Result modify(ModifyRequest request) throws LdapException {
            return this.checkState().modify(request);
        }

        @Override
        public Result modify(String ... ldifLines) throws LdapException {
            return this.checkState().modify(ldifLines);
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request) {
            return this.modifyAsync(request, null);
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().modifyAsync(request, intermediateResponseHandler);
        }

        @Override
        public Result modifyDN(ModifyDNRequest request) throws LdapException {
            return this.checkState().modifyDN(request);
        }

        @Override
        public Result modifyDN(String name, String newRDN) throws LdapException {
            return this.checkState().modifyDN(name, newRDN);
        }

        @Override
        public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request) {
            return this.modifyDNAsync(request, null);
        }

        @Override
        public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.checkState().modifyDNAsync(request, intermediateResponseHandler);
        }

        @Override
        public SearchResultEntry readEntry(DN name, String ... attributeDescriptions) throws LdapException {
            return this.checkState().readEntry(name, attributeDescriptions);
        }

        @Override
        public SearchResultEntry readEntry(String name, String ... attributeDescriptions) throws LdapException {
            return this.checkState().readEntry(name, attributeDescriptions);
        }

        @Override
        public LdapPromise<SearchResultEntry> readEntryAsync(DN name, Collection<String> attributeDescriptions) {
            return this.checkState().readEntryAsync(name, attributeDescriptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            Reject.ifNull((Object)listener);
            Object object = this.stateLock;
            synchronized (object) {
                if (this.listeners != null) {
                    this.listeners.remove(listener);
                }
            }
        }

        @Override
        public ConnectionEntryReader search(SearchRequest request) {
            return this.checkState().search(request);
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws LdapException {
            return this.checkState().search(request, entries);
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries, Collection<? super SearchResultReference> references) throws LdapException {
            return this.checkState().search(request, entries, references);
        }

        @Override
        public Result search(SearchRequest request, SearchResultHandler handler) throws LdapException {
            return this.checkState().search(request, handler);
        }

        @Override
        public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
            return this.checkState().search(baseObject, scope, filter, attributeDescriptions);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, SearchResultHandler resultHandler) {
            return this.searchAsync(request, null, resultHandler);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
            return this.checkState().searchAsync(request, intermediateResponseHandler, entryHandler);
        }

        @Override
        public SearchResultEntry searchSingleEntry(SearchRequest request) throws LdapException {
            return this.checkState().searchSingleEntry(request);
        }

        @Override
        public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws LdapException {
            return this.checkState().searchSingleEntry(baseObject, scope, filter, attributeDescriptions);
        }

        @Override
        public LdapPromise<SearchResultEntry> searchSingleEntryAsync(SearchRequest request) {
            return this.checkState().searchSingleEntryAsync(request);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PooledConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }

        private Connection checkState() {
            if (this.isClosed()) {
                throw new IllegalStateException();
            }
            return this.connection;
        }
    }

    private final class ConnectionFailureHandler
    implements ExceptionHandler<LdapException> {
        private ConnectionFailureHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleException(LdapException exception) {
            CachedConnectionPool.this.pendingConnectionAttempts.decrementAndGet();
            CachedConnectionPool.this.availableConnections.release();
            logger.debug(LocalizableMessage.raw((CharSequence)"Connection attempt failed: availableConnections=%d, maxPoolSize=%d", (Object[])new Object[]{CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize, exception}));
            LinkedList<QueueElement> waitingPromises = new LinkedList<QueueElement>();
            LinkedList linkedList = CachedConnectionPool.this.queue;
            synchronized (linkedList) {
                while (CachedConnectionPool.this.hasWaitingPromises()) {
                    waitingPromises.add((QueueElement)CachedConnectionPool.this.queue.removeFirst());
                }
            }
            for (QueueElement waitingPromise : waitingPromises) {
                waitingPromise.getWaitingPromise().handleException((Exception)exception);
            }
        }
    }

    private final class ConnectionResultHandler
    implements ResultHandler<Connection> {
        private ConnectionResultHandler() {
        }

        public void handleResult(Connection connection) {
            logger.debug(LocalizableMessage.raw((CharSequence)"Connection attempt succeeded:  availableConnections=%d, maxPoolSize=%d", (Object[])new Object[]{CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize}));
            CachedConnectionPool.this.pendingConnectionAttempts.decrementAndGet();
            CachedConnectionPool.this.publishConnection(connection);
        }
    }
}

