/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.io.LDAPMessageHandler;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericIntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.schema.Schema;

public final class LDAPReader<R extends ASN1Reader> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final DecodeOptions options;
    private final R reader;

    LDAPReader(R asn1Reader, DecodeOptions options) {
        this.reader = asn1Reader;
        this.options = options;
    }

    public R getASN1Reader() {
        return this.reader;
    }

    public boolean hasMessageAvailable() throws DecodeException, IOException {
        return this.reader.elementAvailable();
    }

    public void readMessage(LDAPMessageHandler handler) throws DecodeException, IOException {
        this.reader.readStartSequence();
        try {
            int messageID = (int)this.reader.readInteger();
            this.readProtocolOp(messageID, handler);
        }
        finally {
            this.reader.readEndSequence();
        }
    }

    private void readAbandonRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        int msgToAbandon = (int)this.reader.readInteger((byte)80);
        AbandonRequest message = Requests.newAbandonRequest(msgToAbandon);
        this.readControls(message);
        logger.trace("DECODE LDAP ABANDON REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.abandonRequest(messageID, message);
    }

    private void readAddRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        Entry entry = LDAP.readEntry(this.reader, (byte)104, this.options);
        AddRequest message = Requests.newAddRequest(entry);
        this.readControls(message);
        logger.trace("DECODE LDAP ADD REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.addRequest(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAddResult(int messageID, LDAPMessageHandler handler) throws IOException {
        Result message;
        this.reader.readStartSequence((byte)105);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP ADD RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.addResult(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBindRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        this.reader.readStartSequence((byte)96);
        try {
            int protocolVersion = (int)this.reader.readInteger();
            String authName = this.reader.readOctetStringAsString();
            byte authType = this.reader.peekType();
            byte[] authBytes = this.reader.readOctetString(authType).toByteArray();
            GenericBindRequest request = Requests.newGenericBindRequest(authName, authType, authBytes);
            this.readControls(request);
            logger.trace("DECODE LDAP BIND REQUEST(messageID=%d, auth=0x%x, request=%s)", (Object)messageID, (Object)request.getAuthenticationType(), (Object)request);
            handler.bindRequest(messageID, protocolVersion, request);
        }
        finally {
            this.reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBindResult(int messageID, LDAPMessageHandler handler) throws IOException {
        BindResult message;
        this.reader.readStartSequence((byte)97);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newBindResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
            if (this.reader.hasNextElement() && this.reader.peekType() == -121) {
                message.setServerSASLCredentials(this.reader.readOctetString((byte)-121));
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP BIND RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.bindResult(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCompareRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        CompareRequest message;
        this.reader.readStartSequence((byte)110);
        try {
            String dnString = this.reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = LDAP.readDN(dnString, schema);
            this.reader.readStartSequence();
            try {
                String ads = this.reader.readOctetStringAsString();
                AttributeDescription ad = LDAP.readAttributeDescription(ads, schema);
                ByteString assertionValue = this.reader.readOctetString();
                message = Requests.newCompareRequest(dn, ad, (Object)assertionValue);
            }
            finally {
                this.reader.readEndSequence();
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP COMPARE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.compareRequest(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCompareResult(int messageID, LDAPMessageHandler handler) throws IOException {
        CompareResult message;
        this.reader.readStartSequence((byte)111);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newCompareResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP COMPARE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.compareResult(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Control readControl() throws IOException {
        this.reader.readStartSequence();
        try {
            String oid = this.reader.readOctetStringAsString();
            boolean isCritical = this.reader.hasNextElement() && this.reader.peekType() == 1 ? this.reader.readBoolean() : false;
            ByteString value = this.reader.hasNextElement() && this.reader.peekType() == 4 ? this.reader.readOctetString() : null;
            GenericControl genericControl = GenericControl.newControl(oid, isCritical, value);
            return genericControl;
        }
        finally {
            this.reader.readEndSequence();
        }
    }

    private void readControls(Request request) throws IOException {
        if (this.reader.hasNextElement() && this.reader.peekType() == -96) {
            this.reader.readStartSequence((byte)-96);
            try {
                while (this.reader.hasNextElement()) {
                    request.addControl(this.readControl());
                }
            }
            finally {
                this.reader.readEndSequence();
            }
        }
    }

    private void readControls(Response response) throws IOException {
        if (this.reader.hasNextElement() && this.reader.peekType() == -96) {
            this.reader.readStartSequence((byte)-96);
            try {
                while (this.reader.hasNextElement()) {
                    response.addControl(this.readControl());
                }
            }
            finally {
                this.reader.readEndSequence();
            }
        }
    }

    private void readDeleteRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        String dnString = this.reader.readOctetStringAsString((byte)74);
        Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
        DN dn = LDAP.readDN(dnString, schema);
        DeleteRequest message = Requests.newDeleteRequest(dn);
        this.readControls(message);
        logger.trace("DECODE LDAP DELETE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.deleteRequest(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDeleteResult(int messageID, LDAPMessageHandler handler) throws IOException {
        Result message;
        this.reader.readStartSequence((byte)107);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP DELETE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.deleteResult(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExtendedRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        GenericExtendedRequest message;
        this.reader.readStartSequence((byte)119);
        try {
            String oid = this.reader.readOctetStringAsString((byte)-128);
            if (this.reader.hasNextElement() && this.reader.peekType() == -127) {
                ByteString value = this.reader.readOctetString((byte)-127);
                message = Requests.newGenericExtendedRequest(oid, value);
            } else {
                message = Requests.newGenericExtendedRequest(oid, null);
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP EXTENDED REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.extendedRequest(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExtendedResult(int messageID, LDAPMessageHandler handler) throws IOException {
        GenericExtendedResult message;
        this.reader.readStartSequence((byte)120);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newGenericExtendedResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
            if (this.reader.hasNextElement() && this.reader.peekType() == -118) {
                message.setOID(this.reader.readOctetStringAsString((byte)-118));
            }
            if (this.reader.hasNextElement() && this.reader.peekType() == -117) {
                message.setValue(this.reader.readOctetString((byte)-117));
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP EXTENDED RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.extendedResult(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIntermediateResponse(int messageID, LDAPMessageHandler handler) throws IOException {
        GenericIntermediateResponse message;
        this.reader.readStartSequence((byte)121);
        try {
            message = Responses.newGenericIntermediateResponse();
            if (this.reader.hasNextElement() && this.reader.peekType() == -128) {
                message.setOID(this.reader.readOctetStringAsString((byte)-128));
            }
            if (this.reader.hasNextElement() && this.reader.peekType() == -127) {
                message.setValue(this.reader.readOctetString((byte)-127));
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP INTERMEDIATE RESPONSE(messageID=%d, response=%s)", (Object)messageID, (Object)message);
        handler.intermediateResponse(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModifyDNRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        ModifyDNRequest message;
        this.reader.readStartSequence((byte)108);
        try {
            String dnString = this.reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = LDAP.readDN(dnString, schema);
            String newRDNString = this.reader.readOctetStringAsString();
            RDN newRDN = this.readRDN(newRDNString, schema);
            message = Requests.newModifyDNRequest(dn, newRDN);
            message.setDeleteOldRDN(this.reader.readBoolean());
            if (this.reader.hasNextElement() && this.reader.peekType() == -128) {
                String newSuperiorString = this.reader.readOctetStringAsString((byte)-128);
                DN newSuperior = LDAP.readDN(newSuperiorString, schema);
                message.setNewSuperior(newSuperior);
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP MODIFY DN REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.modifyDNRequest(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModifyDNResult(int messageID, LDAPMessageHandler handler) throws IOException {
        Result message;
        this.reader.readStartSequence((byte)109);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP MODIFY DN RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.modifyDNResult(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModifyRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        ModifyRequest message;
        this.reader.readStartSequence((byte)102);
        try {
            String dnString = this.reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = LDAP.readDN(dnString, schema);
            message = Requests.newModifyRequest(dn);
            this.reader.readStartSequence();
            try {
                while (this.reader.hasNextElement()) {
                    this.reader.readStartSequence();
                    try {
                        int typeIntValue = this.reader.readEnumerated();
                        ModificationType type = ModificationType.valueOf(typeIntValue);
                        if (type == null) {
                            throw DecodeException.error(CoreMessages.ERR_LDAP_MODIFICATION_DECODE_INVALID_MOD_TYPE.get((Object)typeIntValue));
                        }
                        this.reader.readStartSequence();
                        try {
                            String ads = this.reader.readOctetStringAsString();
                            AttributeDescription ad = LDAP.readAttributeDescription(ads, schema);
                            Attribute attribute = this.options.getAttributeFactory().newAttribute(ad);
                            this.reader.readStartSet();
                            try {
                                while (this.reader.hasNextElement()) {
                                    attribute.add(this.reader.readOctetString());
                                }
                                message.addModification(new Modification(type, attribute));
                            }
                            finally {
                                this.reader.readEndSet();
                            }
                        }
                        finally {
                            this.reader.readEndSequence();
                        }
                    }
                    finally {
                        this.reader.readEndSequence();
                    }
                }
            }
            finally {
                this.reader.readEndSequence();
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP MODIFY REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.modifyRequest(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModifyResult(int messageID, LDAPMessageHandler handler) throws IOException {
        Result message;
        this.reader.readStartSequence((byte)103);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP MODIFY RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.modifyResult(messageID, message);
    }

    private void readProtocolOp(int messageID, LDAPMessageHandler handler) throws IOException {
        byte type = this.reader.peekType();
        switch (type) {
            case 66: {
                this.readUnbindRequest(messageID, handler);
                break;
            }
            case 74: {
                this.readDeleteRequest(messageID, handler);
                break;
            }
            case 80: {
                this.readAbandonRequest(messageID, handler);
                break;
            }
            case 96: {
                this.readBindRequest(messageID, handler);
                break;
            }
            case 97: {
                this.readBindResult(messageID, handler);
                break;
            }
            case 99: {
                this.readSearchRequest(messageID, handler);
                break;
            }
            case 100: {
                this.readSearchResultEntry(messageID, handler);
                break;
            }
            case 101: {
                this.readSearchResult(messageID, handler);
                break;
            }
            case 102: {
                this.readModifyRequest(messageID, handler);
                break;
            }
            case 103: {
                this.readModifyResult(messageID, handler);
                break;
            }
            case 104: {
                this.readAddRequest(messageID, handler);
                break;
            }
            case 105: {
                this.readAddResult(messageID, handler);
                break;
            }
            case 107: {
                this.readDeleteResult(messageID, handler);
                break;
            }
            case 108: {
                this.readModifyDNRequest(messageID, handler);
                break;
            }
            case 109: {
                this.readModifyDNResult(messageID, handler);
                break;
            }
            case 110: {
                this.readCompareRequest(messageID, handler);
                break;
            }
            case 111: {
                this.readCompareResult(messageID, handler);
                break;
            }
            case 115: {
                this.readSearchResultReference(messageID, handler);
                break;
            }
            case 119: {
                this.readExtendedRequest(messageID, handler);
                break;
            }
            case 120: {
                this.readExtendedResult(messageID, handler);
                break;
            }
            case 121: {
                this.readIntermediateResponse(messageID, handler);
                break;
            }
            default: {
                handler.unrecognizedMessage(messageID, type, this.reader.readOctetString(type));
            }
        }
    }

    private RDN readRDN(String rdn, Schema schema) throws DecodeException {
        try {
            return RDN.valueOf(rdn, schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    private void readResponseReferrals(Result message) throws IOException {
        if (this.reader.hasNextElement() && this.reader.peekType() == -93) {
            this.reader.readStartSequence((byte)-93);
            try {
                do {
                    message.addReferralURI(this.reader.readOctetStringAsString());
                } while (this.reader.hasNextElement());
            }
            finally {
                this.reader.readEndSequence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSearchRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        SearchRequest message;
        this.reader.readStartSequence((byte)99);
        try {
            String baseDNString = this.reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(baseDNString);
            DN baseDN = LDAP.readDN(baseDNString, schema);
            int scopeIntValue = this.reader.readEnumerated();
            SearchScope scope = SearchScope.valueOf(scopeIntValue);
            if (scope == null) {
                throw DecodeException.error(CoreMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_SCOPE.get((Object)scopeIntValue));
            }
            int dereferencePolicyIntValue = this.reader.readEnumerated();
            DereferenceAliasesPolicy dereferencePolicy = DereferenceAliasesPolicy.valueOf(dereferencePolicyIntValue);
            if (dereferencePolicy == null) {
                throw DecodeException.error(CoreMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_DEREF.get((Object)dereferencePolicyIntValue));
            }
            int sizeLimit = (int)this.reader.readInteger();
            int timeLimit = (int)this.reader.readInteger();
            boolean typesOnly = this.reader.readBoolean();
            Filter filter = LDAP.readFilter(this.reader);
            message = Requests.newSearchRequest(baseDN, scope, filter, new String[0]);
            message.setDereferenceAliasesPolicy(dereferencePolicy);
            try {
                message.setTimeLimit(timeLimit);
                message.setSizeLimit(sizeLimit);
            }
            catch (LocalizedIllegalArgumentException e) {
                throw DecodeException.error(e.getMessageObject());
            }
            message.setTypesOnly(typesOnly);
            this.reader.readStartSequence();
            try {
                while (this.reader.hasNextElement()) {
                    message.addAttribute(this.reader.readOctetStringAsString());
                }
            }
            finally {
                this.reader.readEndSequence();
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP SEARCH REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.searchRequest(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSearchResult(int messageID, LDAPMessageHandler handler) throws IOException {
        Result message;
        this.reader.readStartSequence((byte)101);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(message);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP SEARCH RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)message);
        handler.searchResult(messageID, message);
    }

    private void readSearchResultEntry(int messageID, LDAPMessageHandler handler) throws IOException {
        Entry entry = LDAP.readEntry(this.reader, (byte)100, this.options);
        SearchResultEntry message = Responses.newSearchResultEntry(entry);
        this.readControls(message);
        logger.trace("DECODE LDAP SEARCH RESULT ENTRY(messageID=%d, entry=%s)", (Object)messageID, (Object)message);
        handler.searchResultEntry(messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSearchResultReference(int messageID, LDAPMessageHandler handler) throws IOException {
        SearchResultReference message;
        this.reader.readStartSequence((byte)115);
        try {
            message = Responses.newSearchResultReference(this.reader.readOctetStringAsString());
            while (this.reader.hasNextElement()) {
                message.addURI(this.reader.readOctetStringAsString());
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(message);
        logger.trace("DECODE LDAP SEARCH RESULT REFERENCE(messageID=%d, reference=%s)", (Object)messageID, (Object)message);
        handler.searchResultReference(messageID, message);
    }

    private void readUnbindRequest(int messageID, LDAPMessageHandler handler) throws IOException {
        this.reader.readNull((byte)66);
        UnbindRequest message = Requests.newUnbindRequest();
        this.readControls(message);
        logger.trace("DECODE LDAP UNBIND REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        handler.unbindRequest(messageID, message);
    }
}

