/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.LDAPMessageHandler;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

public abstract class AbstractLDAPMessageHandler
implements LDAPMessageHandler {
    protected AbstractLDAPMessageHandler() {
    }

    @Override
    public void abandonRequest(int messageID, AbandonRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void addRequest(int messageID, AddRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void addResult(int messageID, Result result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public void bindRequest(int messageID, int version, GenericBindRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void bindResult(int messageID, BindResult result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public void compareRequest(int messageID, CompareRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void compareResult(int messageID, CompareResult result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public void deleteRequest(int messageID, DeleteRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void deleteResult(int messageID, Result result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public <R extends ExtendedResult> void extendedRequest(int messageID, ExtendedRequest<R> request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void extendedResult(int messageID, ExtendedResult result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public void intermediateResponse(int messageID, IntermediateResponse response) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, response);
    }

    @Override
    public void modifyDNRequest(int messageID, ModifyDNRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void modifyDNResult(int messageID, Result result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public void modifyRequest(int messageID, ModifyRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void modifyResult(int messageID, Result result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public void searchRequest(int messageID, SearchRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void searchResult(int messageID, Result result) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, result);
    }

    @Override
    public void searchResultEntry(int messageID, SearchResultEntry entry) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, entry);
    }

    @Override
    public void searchResultReference(int messageID, SearchResultReference reference) throws DecodeException, IOException {
        throw this.newUnexpectedResponseException(messageID, reference);
    }

    @Override
    public void unbindRequest(int messageID, UnbindRequest request) throws DecodeException, IOException {
        throw this.newUnexpectedRequestException(messageID, request);
    }

    @Override
    public void unrecognizedMessage(int messageID, byte messageTag, ByteString messageBytes) throws DecodeException, IOException {
        throw this.newUnsupportedMessageException(messageID, messageTag, messageBytes);
    }

    protected DecodeException newUnsupportedMessageException(int messageID, byte messageTag, ByteString messageBytes) {
        return DecodeException.fatalError(LocalizableMessage.raw((CharSequence)"Unsupported LDAP message: id=%d, tag=%d, content=%s", (Object[])new Object[]{messageID, messageTag, messageBytes}));
    }

    protected DecodeException newUnexpectedRequestException(int messageID, Request request) {
        return DecodeException.fatalError(LocalizableMessage.raw((CharSequence)"Unexpected LDAP request: id=%d, message=%s", (Object[])new Object[]{messageID, request}));
    }

    protected DecodeException newUnexpectedResponseException(int messageID, Response response) {
        return DecodeException.fatalError(LocalizableMessage.raw((CharSequence)"Unexpected LDAP response: id=%d, message=%s", (Object[])new Object[]{messageID, response}));
    }
}

