/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws;

import org.forgerock.json.jose.jwe.CompressionManager;
import org.forgerock.json.jose.jws.JwsHeader;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.jwt.Jwt;
import org.forgerock.json.jose.jwt.JwtClaimsSet;
import org.forgerock.json.jose.jwt.Payload;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.encode.Base64url;

public class SignedJwt
implements Jwt,
Payload {
    private final JwsHeader header;
    private final Payload payload;
    private final SigningHandler signingHandler;
    private final byte[] signingInput;
    private final byte[] signature;

    public SignedJwt(JwsHeader header, JwtClaimsSet claimsSet, SigningHandler signingHandler) {
        this.header = header;
        this.payload = claimsSet;
        this.signingHandler = signingHandler;
        this.signingInput = null;
        this.signature = null;
    }

    public SignedJwt(JwsHeader header, JwtClaimsSet claimsSet, byte[] signingInput, byte[] signature) {
        this.header = header;
        this.payload = claimsSet;
        this.signingInput = signingInput;
        this.signature = signature;
        this.signingHandler = null;
    }

    protected SignedJwt(JwsHeader header, Payload nestedPayload, SigningHandler signingHandler) {
        this.header = header;
        this.payload = nestedPayload;
        this.signingHandler = signingHandler;
        this.signingInput = null;
        this.signature = null;
    }

    protected SignedJwt(JwsHeader header, Payload nestedPayload, byte[] signingInput, byte[] signature) {
        this.header = header;
        this.payload = nestedPayload;
        this.signingInput = signingInput;
        this.signature = signature;
        this.signingHandler = null;
    }

    @Override
    public JwsHeader getHeader() {
        return this.header;
    }

    @Override
    public JwtClaimsSet getClaimsSet() {
        return (JwtClaimsSet)this.payload;
    }

    protected Payload getPayload() {
        return this.payload;
    }

    @Override
    public String build() {
        String jwsHeader = this.header.build();
        String encodedHeader = Utils.base64urlEncode(jwsHeader);
        String jwsPayload = this.payload.build();
        String encodedClaims = new CompressionManager().compress(this.header.getCompressionAlgorithm(), jwsPayload);
        String signingInput = encodedHeader + "." + encodedClaims;
        byte[] signature = this.signingHandler.sign(this.header.getAlgorithm(), signingInput);
        return signingInput + "." + Base64url.encode((byte[])signature);
    }

    public boolean verify(SigningHandler signingHandler) {
        return signingHandler.verify(this.header.getAlgorithm(), this.signingInput, this.signature);
    }
}

