/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.compression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.forgerock.json.jose.exceptions.JweCompressionException;
import org.forgerock.json.jose.jwe.handlers.compression.CompressionHandler;

public class DeflateCompressionHandler
implements CompressionHandler {
    @Override
    public byte[] compress(byte[] bytes) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteOutputStream, new Deflater(8, true));){
            deflaterOutputStream.write(bytes);
        }
        catch (IOException e) {
            throw new JweCompressionException("Failed to apply compression algorithm.", e);
        }
        return byteOutputStream.toByteArray();
    }

    @Override
    public byte[] decompress(byte[] bytes) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(bytes), new Inflater(true));
             ByteArrayOutputStream out = byteOutputStream;){
            int l;
            byte[] buffer = new byte[1024];
            while ((l = inflaterInputStream.read(buffer)) > 0) {
                out.write(buffer, 0, l);
            }
        }
        catch (IOException e) {
            throw new JweCompressionException("Failed to apply de-compression algorithm.", e);
        }
        return byteOutputStream.toByteArray();
    }
}

