/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import java.util.Map;
import org.forgerock.json.jose.jwe.CompressionAlgorithm;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweAlgorithm;
import org.forgerock.json.jose.jwe.JweHeaderKey;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jws.JwtSecureHeader;

public class JweHeader
extends JwtSecureHeader {
    private static final String ENCRYPTION_METHOD_HEADER_KEY = "enc";
    private static final String EPHEMERAL_PUBLIC_KEY_HEADER_KEY = "epk";
    private static final String AGREEMENT_PARTY_UINFO_HEADER_KEY = "apu";

    public JweHeader() {
    }

    public JweHeader(Map<String, Object> headerParameters) {
        super(headerParameters);
    }

    @Override
    public JweAlgorithm getAlgorithm() {
        return JweAlgorithm.parseAlgorithm(this.getAlgorithmString());
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.put(ENCRYPTION_METHOD_HEADER_KEY, encryptionMethod.toString());
    }

    public EncryptionMethod getEncryptionMethod() {
        return EncryptionMethod.parseMethod(this.get(ENCRYPTION_METHOD_HEADER_KEY).asString());
    }

    public void setEphemeralPublicKey(JWK ephemeralPublicKey) {
        this.put(EPHEMERAL_PUBLIC_KEY_HEADER_KEY, ephemeralPublicKey.toString());
    }

    public String getEphemeralPublicKey() {
        return this.get(EPHEMERAL_PUBLIC_KEY_HEADER_KEY).asString();
    }

    public void setAgreementPartyUInfo(String agreementPartyUInfo) {
        this.put(AGREEMENT_PARTY_UINFO_HEADER_KEY, agreementPartyUInfo);
    }

    public String getAgreementPartyUInfo() {
        return this.get(AGREEMENT_PARTY_UINFO_HEADER_KEY).asString();
    }

    @Override
    public void setParameter(String key, Object value) {
        JweHeaderKey headerKey = JweHeaderKey.getHeaderKey(key.toUpperCase());
        switch (headerKey) {
            case ENC: {
                if (this.isValueOfType(value, EncryptionMethod.class)) {
                    this.setEncryptionMethod((EncryptionMethod)((Object)value));
                }
                this.checkValueIsOfType(value, String.class);
                this.setEncryptionMethod(EncryptionMethod.parseMethod((String)value));
                break;
            }
            case EPK: {
                this.checkValueIsOfType(value, JWK.class);
                this.setEphemeralPublicKey((JWK)value);
                break;
            }
            case ZIP: {
                if (this.isValueOfType(value, CompressionAlgorithm.class)) {
                    this.setCompressionAlgorithm((CompressionAlgorithm)((Object)value));
                }
                this.checkValueIsOfType(value, String.class);
                this.setCompressionAlgorithm(CompressionAlgorithm.parseAlgorithm((String)value));
                break;
            }
            case APU: {
                this.checkValueIsOfType(value, String.class);
                this.setAgreementPartyUInfo((String)value);
                break;
            }
            default: {
                super.setParameter(key, value);
            }
        }
    }

    @Override
    public Object getParameter(String key) {
        Object value;
        JweHeaderKey headerKey = JweHeaderKey.getHeaderKey(key.toUpperCase());
        switch (headerKey) {
            case ENC: {
                value = this.getEncryptionMethod();
                break;
            }
            case EPK: {
                value = this.getEphemeralPublicKey();
                break;
            }
            case ZIP: {
                value = this.getCompressionAlgorithm();
                break;
            }
            case APU: {
                value = this.getAgreementPartyUInfo();
                break;
            }
            default: {
                value = super.getParameter(key);
            }
        }
        return value;
    }
}

