/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import java.util.HashMap;
import java.util.Map;
import org.forgerock.json.jose.builders.JwtBuilder;
import org.forgerock.json.jose.jwt.Algorithm;
import org.forgerock.json.jose.jwt.JwtHeader;

public abstract class JwtHeaderBuilder<T extends JwtBuilder, B extends JwtHeaderBuilder<T, B>> {
    private final T jwtBuilder;
    private final Map<String, Object> headers = new HashMap<String, Object>();

    public JwtHeaderBuilder(T jwtBuilder) {
        this.jwtBuilder = jwtBuilder;
    }

    public B header(String key, Object value) {
        this.headers.put(key, value);
        return (B)this;
    }

    public B headerIfNotNull(String key, Object value) {
        if (value != null) {
            this.header(key, value);
        }
        return (B)this;
    }

    public B alg(Algorithm algorithm) {
        this.header("alg", algorithm.toString());
        return (B)this;
    }

    public T done() {
        return this.jwtBuilder;
    }

    protected Map<String, Object> getHeaders() {
        return this.headers;
    }

    protected abstract JwtHeader build();
}

