/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache.async;

import java.net.ProxySelector;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.apache.NoAuthenticationStrategy;
import org.forgerock.http.apache.async.AsyncHttpClient;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.spi.HttpClient;
import org.forgerock.http.spi.HttpClientProvider;
import org.forgerock.http.util.Lists;
import org.forgerock.util.Factory;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.time.Duration;

public class AsyncHttpClientProvider
implements HttpClientProvider {
    public static final Option<Integer> OPTION_WORKER_THREADS = Option.of(Integer.class, null);
    private static final RedirectStrategy DISABLE_REDIRECT = new RedirectStrategy(){

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    };

    public HttpClient newHttpClient(Options options) throws HttpApplicationException {
        DefaultConnectingIOReactor reactor;
        Integer threadCount;
        SSLContext sslContext;
        Factory storage = (Factory)options.get(HttpClientHandler.OPTION_TEMPORARY_STORAGE);
        try {
            sslContext = SSLContext.getInstance((String)options.get(HttpClientHandler.OPTION_SSLCONTEXT_ALGORITHM));
            sslContext.init((KeyManager[])options.get(HttpClientHandler.OPTION_KEY_MANAGERS), (TrustManager[])options.get(HttpClientHandler.OPTION_TRUST_MANAGERS), null);
        }
        catch (GeneralSecurityException e) {
            throw new HttpApplicationException("Can't create SSL Context", (Throwable)e);
        }
        DefaultHostnameVerifier verifier = new DefaultHostnameVerifier();
        switch ((HttpClientHandler.HostnameVerifier)options.get(HttpClientHandler.OPTION_HOSTNAME_VERIFIER)) {
            case ALLOW_ALL: {
                verifier = NoopHostnameVerifier.INSTANCE;
            }
        }
        List protocols = (List)options.get(HttpClientHandler.OPTION_SSL_ENABLED_PROTOCOLS);
        List ciphers = (List)options.get(HttpClientHandler.OPTION_SSL_CIPHER_SUITES);
        Registry registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslContext, Lists.asArrayOrNull((List)protocols), Lists.asArrayOrNull((List)ciphers), (HostnameVerifier)verifier)).build();
        Duration soTimeout = (Duration)options.get(HttpClientHandler.OPTION_SO_TIMEOUT);
        Duration connectTimeout = (Duration)options.get(HttpClientHandler.OPTION_CONNECT_TIMEOUT);
        IOReactorConfig.Builder reactorBuilder = IOReactorConfig.custom();
        if (!connectTimeout.isUnlimited()) {
            reactorBuilder.setConnectTimeout((int)connectTimeout.to(TimeUnit.MILLISECONDS));
        }
        if (!soTimeout.isUnlimited()) {
            reactorBuilder.setSoTimeout((int)soTimeout.to(TimeUnit.MILLISECONDS));
        }
        if ((threadCount = (Integer)options.get(OPTION_WORKER_THREADS)) != null) {
            reactorBuilder.setIoThreadCount(threadCount.intValue());
        }
        IOReactorConfig ioReactorConfig = reactorBuilder.build();
        try {
            reactor = new DefaultConnectingIOReactor(ioReactorConfig);
        }
        catch (IOReactorException e) {
            throw new HttpApplicationException("Cannot create I/O Reactor", (Throwable)e);
        }
        PoolingNHttpClientConnectionManager manager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)reactor, registry);
        int maxConnections = (Integer)options.get(HttpClientHandler.OPTION_MAX_CONNECTIONS);
        manager.setMaxTotal(maxConnections);
        manager.setDefaultMaxPerRoute(maxConnections);
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom();
        if (!((Boolean)options.get(HttpClientHandler.OPTION_REUSE_CONNECTIONS)).booleanValue()) {
            builder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE);
        }
        AuthenticationStrategy proxyStrategy = NoAuthenticationStrategy.INSTANCE;
        ProxyAuthenticationStrategy proxyAuthenticationStrategy = null;
        HttpClientHandler.ProxyInfo proxyInfo = (HttpClientHandler.ProxyInfo)options.get(HttpClientHandler.OPTION_PROXY);
        if (proxyInfo != null) {
            URI uri = proxyInfo.getProxyUri();
            builder.setProxy(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()));
            if (proxyInfo.hasCredentials()) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(proxyInfo.getUsername(), proxyInfo.getPassword());
                AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
                proxyAuthenticationStrategy = ProxyAuthenticationStrategy.INSTANCE;
            }
        } else if (((Boolean)options.get(HttpClientHandler.OPTION_PROXY_SYSTEM)).booleanValue()) {
            builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        }
        CloseableHttpAsyncClient client = builder.setConnectionManager((NHttpClientConnectionManager)manager).disableCookieManagement().setRedirectStrategy(DISABLE_REDIRECT).setTargetAuthenticationStrategy(NoAuthenticationStrategy.INSTANCE).setProxyAuthenticationStrategy(proxyAuthenticationStrategy).build();
        client.start();
        return new AsyncHttpClient(client, (Factory<Buffer>)storage);
    }
}

