/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import java.net.InetSocketAddress;
import org.forgerock.audit.handlers.syslog.AsynchronousSyslogPublisher;
import org.forgerock.audit.handlers.syslog.SynchronousSyslogPublisher;
import org.forgerock.audit.handlers.syslog.SyslogAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.syslog.SyslogConnection;
import org.forgerock.audit.handlers.syslog.SyslogPublisher;
import org.forgerock.audit.handlers.syslog.TcpSyslogConnection;
import org.forgerock.audit.handlers.syslog.UdpSyslogConnection;

public enum TransportProtocol {
    TCP{

        @Override
        SyslogConnection getSyslogConnection(InetSocketAddress socket, SyslogAuditEventHandlerConfiguration config) {
            return new TcpSyslogConnection(socket, config.getConnectTimeout());
        }
    }
    ,
    UDP{

        @Override
        SyslogConnection getSyslogConnection(InetSocketAddress socket, SyslogAuditEventHandlerConfiguration config) {
            return new UdpSyslogConnection(socket);
        }
    };


    public SyslogPublisher getPublisher(InetSocketAddress socket, SyslogAuditEventHandlerConfiguration config) {
        SyslogConnection syslogConnection = this.getSyslogConnection(socket, config);
        SyslogAuditEventHandlerConfiguration.EventBufferingConfiguration buffering = config.getBuffering();
        if (buffering.isEnabled()) {
            return new AsynchronousSyslogPublisher("SyslogHandler", syslogConnection);
        }
        return new SynchronousSyslogPublisher(syslogConnection);
    }

    abstract SyslogConnection getSyslogConnection(InetSocketAddress var1, SyslogAuditEventHandlerConfiguration var2);
}

