/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.audit.events.AuditEventHelper;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.handlers.syslog.Facility;
import org.forgerock.audit.handlers.syslog.Severity;
import org.forgerock.audit.handlers.syslog.SyslogAuditEventHandlerConfiguration;
import org.forgerock.audit.providers.LocalHostNameProvider;
import org.forgerock.audit.providers.ProductInfoProvider;
import org.forgerock.audit.util.JsonSchemaUtils;
import org.forgerock.audit.util.JsonValueUtils;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyslogFormatter {
    private static final Logger logger = LoggerFactory.getLogger(SyslogFormatter.class);
    private static final String SYSLOG_SPEC_VERSION = "1";
    private static final String NIL_VALUE = "-";
    private final Map<String, StructuredDataFormatter> structuredDataFormatters;
    private final Map<String, SyslogAuditEventHandlerConfiguration.SeverityFieldMapping> severityFieldMappings;
    private final String hostname;
    private final String appName;
    private final String procId;
    private final Facility facility;

    public SyslogFormatter(EventTopicsMetaData eventTopicsMetaData, SyslogAuditEventHandlerConfiguration config, LocalHostNameProvider localHostNameProvider, ProductInfoProvider productInfoProvider) {
        Reject.ifNull((Object)localHostNameProvider, (String)"LocalHostNameProvider must not be null");
        this.hostname = this.getLocalHostName(localHostNameProvider);
        this.procId = String.valueOf(SyslogFormatter.class.hashCode());
        this.appName = this.getProductName(productInfoProvider);
        this.facility = config.getFacility();
        this.severityFieldMappings = this.createSeverityFieldMappings(config.getSeverityFieldMappings(), eventTopicsMetaData);
        this.structuredDataFormatters = Collections.unmodifiableMap(this.createStructuredDataFormatters(this.appName, eventTopicsMetaData));
    }

    public String format(String topic, JsonValue auditEvent) {
        Reject.ifFalse((boolean)this.canFormat(topic), (String)"Unknown event topic");
        Severity severity = this.getSeverityLevel(topic, auditEvent);
        String priority = String.valueOf(this.calculatePriorityValue(this.facility, severity));
        String timestamp = auditEvent.get("timestamp").asString();
        String msgId = auditEvent.get("eventName").asString();
        String structuredData = this.structuredDataFormatters.get(topic).format(auditEvent);
        String msg = "";
        return "<" + priority + ">" + SYSLOG_SPEC_VERSION + " " + timestamp + " " + this.hostname + " " + this.appName + " " + this.procId + " " + msgId + " " + structuredData + " " + "";
    }

    public boolean canFormat(String topic) {
        return this.structuredDataFormatters.containsKey(topic);
    }

    private Map<String, SyslogAuditEventHandlerConfiguration.SeverityFieldMapping> createSeverityFieldMappings(List<SyslogAuditEventHandlerConfiguration.SeverityFieldMapping> mappings, EventTopicsMetaData eventTopicsMetaData) {
        HashMap<String, SyslogAuditEventHandlerConfiguration.SeverityFieldMapping> results = new HashMap<String, SyslogAuditEventHandlerConfiguration.SeverityFieldMapping>(mappings.size());
        for (SyslogAuditEventHandlerConfiguration.SeverityFieldMapping mapping : mappings) {
            JsonValue auditEventSchema;
            if (results.containsKey(mapping.getTopic())) {
                logger.warn("Multiple Syslog severity field mappings defined for {} topic", (Object)mapping.getTopic());
                continue;
            }
            if (!eventTopicsMetaData.containsTopic(mapping.getTopic())) {
                logger.warn("Syslog severity field mapping defined for unknown topic {}", (Object)mapping.getTopic());
                continue;
            }
            JsonValue auditEventMetaData = eventTopicsMetaData.getSchema(mapping.getTopic());
            try {
                auditEventSchema = AuditEventHelper.getAuditEventSchema((JsonValue)auditEventMetaData);
            }
            catch (ResourceException e) {
                logger.warn(e.getMessage());
                continue;
            }
            Set topicFieldPointers = JsonSchemaUtils.generateJsonPointers((JsonValue)auditEventSchema);
            String mappedField = mapping.getField();
            if (mappedField != null && !mappedField.startsWith("/")) {
                mappedField = "/" + mappedField;
            }
            if (!topicFieldPointers.contains(mappedField)) {
                logger.warn("Syslog severity field mapping for topic {} references unknown field {}", (Object)mapping.getTopic(), (Object)mapping.getField());
                continue;
            }
            results.put(mapping.getTopic(), mapping);
        }
        return results;
    }

    private Map<String, StructuredDataFormatter> createStructuredDataFormatters(String productName, EventTopicsMetaData eventTopicsMetaData) {
        HashMap<String, StructuredDataFormatter> results = new HashMap<String, StructuredDataFormatter>();
        for (String topic : eventTopicsMetaData.getTopics()) {
            JsonValue schema = eventTopicsMetaData.getSchema(topic);
            results.put(topic, new StructuredDataFormatter(productName, topic, schema));
        }
        return results;
    }

    private Severity getSeverityLevel(String topic, JsonValue auditEvent) {
        if (this.severityFieldMappings.containsKey(topic)) {
            JsonValue jsonValue;
            String severityValue;
            SyslogAuditEventHandlerConfiguration.SeverityFieldMapping severityFieldMapping = this.severityFieldMappings.get(topic);
            String severityField = severityFieldMapping.getField();
            if (severityField != null && !severityField.startsWith("/")) {
                severityField = "/" + severityField;
            }
            String string = severityValue = (jsonValue = auditEvent.get(new JsonPointer(severityField))) == null ? null : jsonValue.asString();
            if (severityValue == null) {
                logger.debug("{} value not set; defaulting to INFORMATIONAL Syslog SEVERITY level", (Object)severityField);
            } else {
                try {
                    return Severity.valueOf(severityValue);
                }
                catch (IllegalArgumentException ex) {
                    logger.debug("{} is not a valid Syslog SEVERITY level; defaulting to INFORMATIONAL", (Object)severityValue);
                }
            }
        }
        return Severity.INFORMATIONAL;
    }

    private int calculatePriorityValue(Facility facility, Severity severityLevel) {
        return facility.getCode() * 8 + severityLevel.getCode();
    }

    private String getLocalHostName(LocalHostNameProvider localHostNameProvider) {
        String localHostName = localHostNameProvider.getLocalHostName();
        return localHostName != null ? localHostName : NIL_VALUE;
    }

    private String getProductName(ProductInfoProvider productInfoProvider) {
        String productName = productInfoProvider.getProductName();
        return productName != null ? productName : NIL_VALUE;
    }

    private static class StructuredDataFormatter {
        private static final String FORGEROCK_IANA_ENTERPRISE_ID = "36733";
        private static final Set<String> IGNORED_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", "timestamp", "eventName")));
        private final String id;
        private final Set<String> fieldNames;

        public StructuredDataFormatter(String productName, String topic, JsonValue auditEventMetaData) {
            JsonValue auditEventSchema;
            Reject.ifNull((Object)productName, (String)"Product name required.");
            Reject.ifNull((Object)topic, (String)"Audit event topic name required.");
            try {
                auditEventSchema = AuditEventHelper.getAuditEventSchema((JsonValue)auditEventMetaData);
            }
            catch (ResourceException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            this.id = topic + "." + productName + "@" + FORGEROCK_IANA_ENTERPRISE_ID;
            this.fieldNames = Collections.unmodifiableSet(JsonSchemaUtils.generateJsonPointers((JsonValue)auditEventSchema));
        }

        public String format(JsonValue auditEvent) {
            StringBuilder sd = new StringBuilder();
            sd.append("[");
            sd.append(this.id);
            for (String fieldName : this.fieldNames) {
                String formattedName = this.formatParamName(fieldName);
                if (IGNORED_FIELDS.contains(formattedName)) continue;
                sd.append(" ");
                sd.append(formattedName);
                sd.append("=\"");
                sd.append(this.formatParamValue(JsonValueUtils.extractValueAsString((JsonValue)auditEvent, (String)fieldName)));
                sd.append("\"");
            }
            sd.append("]");
            return sd.toString();
        }

        private String formatParamName(String name) {
            return AuditEventHelper.jsonPointerToDotNotation((String)name);
        }

        private String formatParamValue(String value) {
            if (value == null) {
                return "";
            }
            return value.replaceAll("[\\\\\"\\]]", "\\\\$0");
        }
    }
}

