/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpTableSupport;
import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opends.server.snmp.DsIntEntry;
import org.opends.server.snmp.DsIntEntryMBean;

public class TableDsIntTable
extends SnmpTableSupport
implements Serializable {
    protected MBeanServer server;

    public TableDsIntTable(SnmpMib myMib) {
        super(myMib);
    }

    public TableDsIntTable(SnmpMib myMib, MBeanServer server) {
        this(myMib);
        this.server = server;
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth, SnmpMibTable meta) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(rowOid);
        Vector v = index.getComponents();
        try {
            SnmpOid oid0 = (SnmpOid)v.elementAt(0);
            SnmpOid oid1 = (SnmpOid)v.elementAt(1);
            SnmpOid oid2 = (SnmpOid)v.elementAt(2);
            ObjectName objname = null;
            if (this.server != null) {
                objname = this.buildNameFromIndex(index);
            }
            Object entry = this.createDsIntEntryMBean(req, rowOid, depth, objname, meta, oid0.toInteger(), oid1.toInteger(), oid2.toInteger());
            if (this.server != null) {
                this.server.registerMBean(entry, objname);
            }
            meta.addEntry(rowOid, objname, entry);
        }
        catch (SnmpStatusException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    protected SnmpMibTable getRegisteredTableMeta(SnmpMib mib) {
        return mib.getRegisteredTableMeta("DsIntTable");
    }

    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            super.removeEntryCb(pos, row, name, entry, meta);
            if (this.server != null && name != null) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addEntry(DsIntEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, (Object)entry);
    }

    public synchronized void addEntry(DsIntEntryMBean entry, ObjectName name) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, name, (Object)entry);
    }

    public synchronized DsIntEntryMBean[] getEntries() {
        Object[] array = this.getBasicEntries();
        DsIntEntryMBean[] result = new DsIntEntryMBean[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public void removeEntry(DsIntEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.removeEntry(index, (Object)entry);
    }

    public ObjectName buildNameFromIndex(SnmpIndex index) throws SnmpStatusException {
        Vector v = index.getComponents();
        try {
            SnmpOid oid = (SnmpOid)v.elementAt(0);
            String _keyApplIndex = oid.toInteger().toString();
            oid = (SnmpOid)v.elementAt(1);
            String _keyDsIntEntIndex = oid.toInteger().toString();
            oid = (SnmpOid)v.elementAt(2);
            String _keyDsApplIfProtocolIndex = oid.toInteger().toString();
            return new ObjectName("TableDsIntTable:name=org.opends.server.snmp.DsIntEntry,ApplIndex=" + _keyApplIndex + ",DsIntEntIndex=" + _keyDsIntEntIndex + ",DsApplIfProtocolIndex=" + _keyDsApplIfProtocolIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    public SnmpIndex buildSnmpIndex(DsIntEntryMBean entry) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[3];
        SnmpInt val = null;
        val = new SnmpInt(entry.getApplIndex());
        oids[0] = val.toOid();
        val = new SnmpInt(entry.getDsIntEntIndex());
        oids[1] = val.toOid();
        val = new SnmpInt(entry.getDsApplIfProtocolIndex());
        oids[2] = val.toOid();
        return new SnmpIndex(oids);
    }

    public SnmpOid buildOidFromIndex(SnmpIndex index) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        if (index.getNbComponents() != 3) {
            throw new SnmpStatusException(224);
        }
        try {
            Vector v = index.getComponents();
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)v.elementAt(0)), (SnmpOid)oid);
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)v.elementAt(1)), (SnmpOid)oid);
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)v.elementAt(2)), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpOid buildOidFromIndexVal(Integer aApplIndex, Integer aDsIntEntIndex, Integer aDsApplIfProtocolIndex) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        try {
            SnmpInt.appendToOid((SnmpOid)new SnmpInt(aApplIndex).toOid(), (SnmpOid)oid);
            SnmpInt.appendToOid((SnmpOid)new SnmpInt(aDsIntEntIndex).toOid(), (SnmpOid)oid);
            SnmpInt.appendToOid((SnmpOid)new SnmpInt(aDsApplIfProtocolIndex).toOid(), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpIndex buildSnmpIndex(long[] index, int start) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[3];
        int pos = start;
        oids[0] = SnmpInt.toOid((long[])index, (int)pos);
        pos = SnmpInt.nextOid((long[])index, (int)pos);
        oids[1] = SnmpInt.toOid((long[])index, (int)pos);
        pos = SnmpInt.nextOid((long[])index, (int)pos);
        oids[2] = SnmpInt.toOid((long[])index, (int)pos);
        return new SnmpIndex(oids);
    }

    public Object createDsIntEntryMBean(SnmpMibSubRequest req, SnmpOid rowOid, int depth, ObjectName entryObjName, SnmpMibTable meta, Integer aApplIndex, Integer aDsIntEntIndex, Integer aDsApplIfProtocolIndex) throws SnmpStatusException {
        DsIntEntry entry = new DsIntEntry(this.theMib);
        entry.ApplIndex = aApplIndex;
        entry.DsIntEntIndex = aDsIntEntIndex;
        entry.DsApplIfProtocolIndex = aDsApplIfProtocolIndex;
        return entry;
    }
}

