/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.InetAddressAcl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import org.forgerock.opendj.server.config.server.SNMPConnectionHandlerCfg;

public class SNMPInetAddressAcl
implements InetAddressAcl {
    private SNMPConnectionHandlerCfg currentConfig;
    private static final String ALL_MANAGERS_ALLOWED = "*";
    private Set<InetAddress> hostsList;
    private boolean allManagers = false;
    private SortedSet<String> trapsDestinations;
    private String trapsCommunity;
    private String communities;

    public SNMPInetAddressAcl(SNMPConnectionHandlerCfg configuration) {
        this.currentConfig = configuration;
        SortedSet tmp = this.currentConfig.getAllowedManager();
        if (tmp.contains(ALL_MANAGERS_ALLOWED)) {
            this.allManagers = true;
        }
        this.hostsList = new HashSet<InetAddress>();
        for (String dest : tmp) {
            try {
                this.hostsList.add(InetAddress.getByName(dest));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        this.trapsDestinations = this.currentConfig.getTrapsDestination();
        this.communities = this.currentConfig.getCommunity();
        this.trapsCommunity = this.currentConfig.getTrapsCommunity();
    }

    public String getName() {
        return "OpenDS";
    }

    public boolean checkReadPermission(InetAddress address) {
        if (this.allManagers) {
            return true;
        }
        if (this.hostsList == null || this.hostsList.isEmpty()) {
            return false;
        }
        return this.hostsList.contains(address);
    }

    public boolean checkReadPermission(InetAddress address, String community) {
        return this.checkReadPermission(address) && this.checkCommunity(community);
    }

    public boolean checkCommunity(String community) {
        return this.communities.equals(community);
    }

    public boolean checkWritePermission(InetAddress address) {
        return false;
    }

    public boolean checkWritePermission(InetAddress address, String community) {
        return false;
    }

    public Enumeration getTrapDestinations() {
        Vector<InetAddress> tempDests = new Vector<InetAddress>();
        for (String dest : this.trapsDestinations) {
            try {
                tempDests.add(InetAddress.getByName(dest));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return tempDests.elements();
    }

    public Enumeration getTrapCommunities(InetAddress address) {
        Vector<String> trapCommunities = new Vector<String>();
        trapCommunities.add(this.trapsCommunity);
        return trapCommunities.elements();
    }

    public Enumeration getInformDestinations() {
        Vector informDests = new Vector();
        return informDests.elements();
    }

    public Enumeration getInformCommunities(InetAddress address) {
        Vector informCommunities = new Vector();
        return informCommunities.elements();
    }
}

