/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.UserAcl;
import com.sun.management.snmp.agent.SnmpMibHandler;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.SortedSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.server.config.server.SNMPConnectionHandlerCfg;
import org.forgerock.util.Reject;
import org.opends.messages.ProtocolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.snmp.DIRECTORY_SERVER_MIBImpl;
import org.opends.server.snmp.SNMPInetAddressAcl;
import org.opends.server.snmp.SNMPUserAcl;
import org.opends.server.util.StaticUtils;

public class SNMPClassLoaderProvider {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private SNMPConnectionHandlerCfg currentConfig;
    private MBeanServer server;
    private DIRECTORY_SERVER_MIBImpl dsMib;
    private ObjectName mibObjName;
    private ObjectName snmpObjName;
    private int snmpPort = 161;
    private int snmpTrapPort = 162;
    private boolean registeredSNMPMBeans = false;
    private String connectionHandlerName;
    private ObjectName UsmObjName;
    private SnmpV3AdaptorServer snmpAdaptor;
    private String contextName;
    private boolean sentTraps = true;

    public void initializeConnectionHandler(SNMPConnectionHandlerCfg configuration) throws Exception {
        this.currentConfig = configuration;
        this.server = DirectoryServer.getJMXMBeanServer();
        this.initializeConnectionHandler();
    }

    public ConfigChangeResult applyConfigurationChange(SNMPConnectionHandlerCfg configuration) {
        try {
            if (this.registeredSNMPMBeans && !configuration.isRegisteredMbean()) {
                this.unregisterSnmpMBeans();
                this.registeredSNMPMBeans = configuration.isRegisteredMbean();
            } else if (!this.registeredSNMPMBeans && configuration.isRegisteredMbean()) {
                this.unregisterSnmpMBeans();
                this.registeredSNMPMBeans = configuration.isRegisteredMbean();
            }
            if (this.snmpPort != configuration.getListenPort()) {
                this.server.unregisterMBean(this.snmpObjName);
                this.snmpAdaptor.stop();
                this.snmpPort = configuration.getListenPort();
                this.snmpAdaptor = this.getSnmpAdaptor(configuration);
                this.snmpObjName = new ObjectName("org.opends.server.snmp:class=SnmpAdaptorServer,protocol=snmp,port=" + this.snmpPort);
                this.server.registerMBean(this.snmpAdaptor, this.snmpObjName);
                this.snmpAdaptor.start();
                if (this.snmpTrapPort != configuration.getTrapPort()) {
                    this.snmpTrapPort = configuration.getTrapPort();
                    this.snmpAdaptor.setTrapPort(Integer.valueOf(this.snmpTrapPort));
                    this.snmpAdaptor.snmpV1Trap(0, 0, null);
                }
            }
        }
        catch (Exception ex) {
            logger.traceException((Throwable)ex);
        }
        return new ConfigChangeResult();
    }

    public ObjectName getUsmMIBName() {
        return this.UsmObjName;
    }

    private void initializeConnectionHandler() throws Exception {
        this.connectionHandlerName = "SNMP Connection Handler " + this.currentConfig.getListenPort();
        this.snmpPort = this.currentConfig.getListenPort();
        this.snmpTrapPort = this.currentConfig.getTrapPort();
        this.registeredSNMPMBeans = this.currentConfig.isRegisteredMbean();
        this.contextName = this.currentConfig.getCommunity();
        try {
            this.snmpObjName = new ObjectName("org.opends.server.snmp:class=SnmpAdaptorServer,protocol=snmp,port=" + this.snmpPort);
            this.snmpAdaptor = this.getSnmpAdaptor(this.currentConfig);
            if (this.snmpAdaptor == null) {
                throw new Exception(ProtocolMessages.ERR_SNMP_CONNHANDLER_BAD_CONFIGURATION.get().toString());
            }
            if (this.registeredSNMPMBeans) {
                this.UsmObjName = new ObjectName("org.opends.server.snmp:type=USM_MIB");
                try {
                    this.snmpAdaptor.registerUsmMib(this.server, this.UsmObjName);
                }
                catch (Exception ex) {
                    throw new Exception(ProtocolMessages.ERR_SNMP_CONNHANDLER_BAD_CONFIGURATION.get().toString());
                }
            }
            this.snmpAdaptor.start();
            while (this.snmpAdaptor.getState() == 3) {
                Thread.sleep(1000L);
            }
            if (this.snmpAdaptor.getState() != 0) {
                throw new Exception(ProtocolMessages.ERR_SNMP_CONNHANDLER_BAD_CONFIGURATION.get().toString());
            }
            this.sentTraps = this.checkTrapsDestinations(this.currentConfig.getTrapsDestination());
            if (!this.sentTraps) {
                logger.error(ProtocolMessages.ERR_SNMP_CONNHANDLER_NO_VALID_TRAP_DESTINATIONS);
            } else {
                this.snmpAdaptor.setTrapPort(Integer.valueOf(this.snmpTrapPort));
                this.snmpAdaptor.snmpV1Trap(null, this.currentConfig.getTrapsCommunity(), 0, 0, null);
            }
            this.mibObjName = new ObjectName("org.opends.server.snmp:class=DIRECTORY_SERVER_MIB");
            this.dsMib = new DIRECTORY_SERVER_MIBImpl(this.registeredSNMPMBeans, this.mibObjName);
            this.dsMib.preRegister(this.server, this.mibObjName);
            this.dsMib.setSnmpAdaptor((SnmpMibHandler)this.snmpAdaptor, this.contextName);
            this.server.registerMBean(this.snmpAdaptor, this.snmpObjName);
        }
        catch (Exception ex) {
            throw new Exception(ProtocolMessages.ERR_SNMP_CONNHANDLER_BAD_CONFIGURATION.get().toString());
        }
    }

    public void finalizeConnectionHandler() {
        try {
            if (this.sentTraps) {
                this.snmpAdaptor.snmpV1Trap(null, this.currentConfig.getTrapsCommunity(), 0, 0, null);
            }
            this.snmpAdaptor.getMibs();
            this.snmpAdaptor.stop();
            this.server.unregisterMBean(this.snmpObjName);
            if (this.server.isRegistered(this.mibObjName)) {
                this.server.unregisterMBean(this.mibObjName);
            }
            this.server.unregisterMBean(new ObjectName("org.opends.server.snmp:type=group,name=DsMib"));
            if (this.registeredSNMPMBeans) {
                this.unregisterSnmpMBeans();
                this.server.unregisterMBean(this.UsmObjName);
            }
        }
        catch (Exception ex) {
            logger.traceException((Throwable)ex);
        }
    }

    private void unregisterSnmpMBeans() {
        for (ObjectName name : this.dsMib.getMib().getEntriesObjectNames()) {
            try {
                this.server.unregisterMBean(name);
            }
            catch (Exception exception) {}
        }
    }

    private SnmpV3AdaptorServer getSnmpAdaptor(SNMPConnectionHandlerCfg configuration) {
        Reject.ifNull((Object)configuration);
        SnmpV3AdaptorServer adaptor = null;
        try {
            String usmConfigPath = configuration.getSecurityAgentFile();
            File file = StaticUtils.getFileForPath((String)usmConfigPath);
            if (!file.isFile() || !file.exists()) {
                return null;
            }
            System.setProperty("jdmk.security.file", file.getAbsolutePath());
            SnmpEngineParameters engineParameters = new SnmpEngineParameters();
            engineParameters.activateEncryption();
            SNMPUserAcl uacls = new SNMPUserAcl(configuration);
            engineParameters.setUserAcl((UserAcl)uacls);
            SNMPInetAddressAcl acls = new SNMPInetAddressAcl(configuration);
            adaptor = new SnmpV3AdaptorServer(engineParameters, null, (InetAddressAcl)acls, configuration.getListenPort(), null);
            adaptor.enableCommunityStringAtContext();
            return adaptor;
        }
        catch (Exception ex) {
            logger.trace("Could not instanciate the SNMP Adaptor");
            return null;
        }
    }

    private boolean checkTrapsDestinations(SortedSet<String> destinations) {
        if (destinations == null || destinations.isEmpty()) {
            return true;
        }
        boolean found = false;
        for (String dest : destinations) {
            try {
                InetAddress.getByName(dest);
                found = true;
            }
            catch (UnknownHostException ex) {
                logger.error(ProtocolMessages.ERR_SNMP_CONNHANDLER_TRAPS_DESTINATION, (Object)dest);
            }
        }
        return found;
    }
}

