/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.agent.SnmpMib;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.server.snmp.DsApplIfOpsEntry;
import org.opends.server.snmp.DsEntry;
import org.opends.server.snmp.SNMPMonitor;

public class DsApplIfOpsEntryImpl
extends DsApplIfOpsEntry
implements DsEntry {
    private static final long serialVersionUID = 3876259684025799091L;
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private ObjectName entryName;
    private MBeanServer server;
    private ObjectName connectionHandlerName;
    private SNMPMonitor monitor;
    private ObjectName stats;

    public DsApplIfOpsEntryImpl(SnmpMib mib, MBeanServer server, ObjectName connectionHandlerObjectName, int applIndex, int connectionHandlerIndex) {
        super(mib);
        this.server = server;
        this.connectionHandlerName = connectionHandlerObjectName;
        this.ApplIndex = new Integer(applIndex);
        this.DsApplIfProtocolIndex = new Integer(connectionHandlerIndex);
        this.monitor = SNMPMonitor.getMonitor(server);
    }

    @Override
    public String getDsApplIfProtocol() {
        String portNumber = (String)this.monitor.getAttribute(this.connectionHandlerName, "ds-connectionhandler-listener");
        if (portNumber == null) {
            return this.DsApplIfProtocol;
        }
        int index = portNumber.lastIndexOf(":");
        if (index == -1) {
            return this.DsApplIfProtocol;
        }
        return new String("1.3.6.1..27.3.") + portNumber.substring(index + 1);
    }

    @Override
    public Long getDsApplIfSearchOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "searchRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfOneLevelSearchOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "searchOneRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfWholeSubtreeSearchOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "searchSubRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfModifyRDNOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "modifyDNRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfModifyEntryOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "modifyRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfRemoveEntryOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "deleteRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfAddEntryOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "addRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfCompareOps() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "compareRequests"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfReadOps() {
        return this.getDsApplIfCompareOps() + this.getDsApplIfAddEntryOps() + this.getDsApplIfRemoveEntryOps() + this.getDsApplIfModifyEntryOps() + this.getDsApplIfModifyRDNOps() + this.getDsApplIfSearchOps();
    }

    @Override
    public Long getDsApplIfOutBytes() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "bytesWritten"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Long getDsApplIfInBytes() {
        if (this.stats == null) {
            this.stats = this.monitor.getConnectionHandlerStatistics(this.connectionHandlerName);
        }
        if (this.stats != null) {
            long value = Long.parseLong((String)this.monitor.getAttribute(this.stats, "bytesRead"));
            return SNMPMonitor.counter32Value(value);
        }
        return 0L;
    }

    @Override
    public Integer getDsApplIfProtocolIndex() {
        return this.DsApplIfProtocolIndex;
    }

    @Override
    public Integer getApplIndex() {
        return this.ApplIndex;
    }

    @Override
    public ObjectName getObjectName() {
        if (this.entryName == null) {
            try {
                String name = this.connectionHandlerName.getKeyProperty("Rdn2");
                this.entryName = new ObjectName("org.opends.server.snmp:type=DsApplIfOpsEntry,name=" + name);
            }
            catch (Exception ex) {
                logger.traceException((Throwable)ex);
                return null;
            }
        }
        return this.entryName;
    }
}

