/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.forgerock.audit.handlers.syslog.SyslogConnection;

class UdpSyslogConnection
implements SyslogConnection {
    private final SocketAddress socketAddress;
    private DatagramSocket datagramSocket;

    public UdpSyslogConnection(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    @Override
    public void reconnect() throws IOException {
        if (this.datagramSocket == null) {
            this.datagramSocket = new DatagramSocket();
        }
    }

    @Override
    public void send(byte[] syslogMessage) throws IOException {
        DatagramPacket packet = new DatagramPacket(syslogMessage, syslogMessage.length, this.socketAddress);
        this.datagramSocket.send(packet);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
        }
        this.datagramSocket = null;
    }
}

