/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;
import org.forgerock.audit.handlers.syslog.Facility;
import org.forgerock.audit.handlers.syslog.Severity;
import org.forgerock.audit.handlers.syslog.TransportProtocol;

public class SyslogAuditEventHandlerConfiguration
extends EventHandlerConfiguration {
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.syslog.transportProtocol")
    private TransportProtocol protocol;
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.syslog.host")
    private String host;
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.syslog.port")
    private int port;
    @JsonPropertyDescription(value="audit.handlers.syslog.connectTimeout")
    private int connectTimeout;
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.syslog.facility")
    private Facility facility;
    @JsonProperty
    @JsonPropertyDescription(value="audit.handlers.syslog.severityFieldMappings")
    private List<SeverityFieldMapping> severityFieldMappings = new ArrayList<SeverityFieldMapping>();
    @JsonPropertyDescription(value="audit.handlers.syslog.buffering")
    protected EventBufferingConfiguration buffering = new EventBufferingConfiguration();

    public TransportProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TransportProtocol protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Facility getFacility() {
        return this.facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public List<SeverityFieldMapping> getSeverityFieldMappings() {
        return this.severityFieldMappings;
    }

    public void setSeverityFieldMappings(List<SeverityFieldMapping> severityFieldMappings) {
        this.severityFieldMappings = severityFieldMappings;
    }

    public EventBufferingConfiguration getBuffering() {
        return this.buffering;
    }

    public void setBufferingConfiguration(EventBufferingConfiguration bufferingConfiguration) {
        this.buffering = bufferingConfiguration;
    }

    public boolean isUsableForQueries() {
        return false;
    }

    public static class EventBufferingConfiguration {
        @JsonPropertyDescription(value="audit.handlers.syslog.buffering.enabled")
        private boolean enabled;
        @JsonPropertyDescription(value="audit.handlers.syslog.buffering.maxSize")
        private int maxSize = 5000;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static final class SeverityFieldMapping {
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="audit.handlers.syslog.severityFieldMapping.topic")
        private String topic;
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="audit.handlers.syslog.severityFieldMapping.field")
        private String field;
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="audit.handlers.syslog.severityFieldMapping.valueMappings")
        private Map<String, Severity> valueMappings = new HashMap<String, Severity>();

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Map<String, Severity> getValueMappings() {
            return Collections.unmodifiableMap(this.valueMappings);
        }

        public void setValueMappings(Map<String, Severity> valueMappings) {
            this.valueMappings = new HashMap<String, Severity>(valueMappings);
        }
    }
}

