/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.forgerock.audit.handlers.syslog.SyslogConnection;
import org.forgerock.audit.handlers.syslog.SyslogPublisher;
import org.forgerock.util.Reject;

class SynchronousSyslogPublisher
implements SyslogPublisher {
    private final SyslogConnection connection;

    SynchronousSyslogPublisher(SyslogConnection connection) {
        Reject.ifNull((Object)connection);
        this.connection = connection;
    }

    @Override
    public void publishMessage(String syslogMessage) throws IOException {
        this.connection.reconnect();
        this.connection.send(syslogMessage.getBytes(StandardCharsets.UTF_8));
        this.connection.flush();
    }

    @Override
    public void close() {
        this.connection.close();
    }
}

