/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.security.KeyStore;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.security.ExternalKeyWrappingStrategy;
import org.forgerock.opendj.security.KeyStoreObjectCache;
import org.forgerock.opendj.security.OpenDJProvider;
import org.forgerock.util.Factory;
import org.forgerock.util.Option;
import org.forgerock.util.Options;

public final class KeyStoreParameters
implements KeyStore.LoadStoreParameter {
    public static final Option<Factory<char[]>> GLOBAL_PASSWORD = Option.of(Factory.class, OpenDJProvider.newClearTextPasswordFactory(null));
    public static final Option<KeyStoreObjectCache> CACHE = Option.withDefault((Object)KeyStoreObjectCache.NONE);
    public static final Option<Integer> PBKDF2_ITERATIONS = Option.withDefault((Object)10000);
    public static final Option<Integer> PBKDF2_SALT_SIZE = Option.withDefault((Object)16);
    public static final Option<ExternalKeyWrappingStrategy> EXTERNAL_KEY_WRAPPING_STRATEGY = Option.of(ExternalKeyWrappingStrategy.class, null);
    private final ConnectionFactory factory;
    private final DN baseDN;
    private final Options options;

    public static KeyStoreParameters newKeyStoreParameters(ConnectionFactory factory, DN baseDN) {
        return KeyStoreParameters.newKeyStoreParameters(factory, baseDN, Options.defaultOptions());
    }

    public static KeyStoreParameters newKeyStoreParameters(ConnectionFactory factory, DN baseDN, Options options) {
        return new KeyStoreParameters(factory, baseDN, options);
    }

    private KeyStoreParameters(ConnectionFactory factory, DN baseDN, Options options) {
        this.factory = factory;
        this.baseDN = baseDN;
        this.options = options;
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter() {
        throw new IllegalStateException();
    }

    Options getOptions() {
        return this.options;
    }

    Connection getConnection() throws LdapException {
        return this.getConnectionFactory().getConnection();
    }

    ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    DN getBaseDN() {
        return this.baseDN;
    }
}

