/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.List;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldif.AbstractLDIFWriter;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.util.Reject;

public final class LDIFEntryWriter
extends AbstractLDIFWriter
implements EntryWriter {
    public static String toString(Entry entry) {
        StringWriter writer = new StringWriter(128);
        try (LDIFEntryWriter ldifWriter = new LDIFEntryWriter(writer);){
            ldifWriter.setAddUserFriendlyComments(true).writeEntry(entry);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public LDIFEntryWriter(List<String> ldifLines) {
        super(ldifLines);
    }

    public LDIFEntryWriter(OutputStream out) {
        super(out);
    }

    public LDIFEntryWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    @Override
    public void flush() throws IOException {
        this.flush0();
    }

    public LDIFEntryWriter setAddUserFriendlyComments(boolean addUserFriendlyComments) {
        this.addUserFriendlyComments = addUserFriendlyComments;
        return this;
    }

    public LDIFEntryWriter setExcludeAllOperationalAttributes(boolean excludeOperationalAttributes) {
        this.excludeOperationalAttributes = excludeOperationalAttributes;
        return this;
    }

    public LDIFEntryWriter setExcludeAllUserAttributes(boolean excludeUserAttributes) {
        this.excludeUserAttributes = excludeUserAttributes;
        return this;
    }

    public LDIFEntryWriter setExcludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        this.excludeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFEntryWriter setExcludeBranch(DN excludeBranch) {
        Reject.ifNull((Object)excludeBranch);
        this.excludeBranches.add(excludeBranch);
        return this;
    }

    public LDIFEntryWriter setExcludeFilter(Matcher excludeFilter) {
        Reject.ifNull((Object)excludeFilter);
        this.excludeFilters.add(excludeFilter);
        return this;
    }

    public LDIFEntryWriter setIncludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        this.includeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFEntryWriter setIncludeBranch(DN includeBranch) {
        Reject.ifNull((Object)includeBranch);
        this.includeBranches.add(includeBranch);
        return this;
    }

    public LDIFEntryWriter setIncludeFilter(Matcher includeFilter) {
        Reject.ifNull((Object)includeFilter);
        this.includeFilters.add(includeFilter);
        return this;
    }

    public LDIFEntryWriter setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
        return this;
    }

    @Override
    public LDIFEntryWriter writeComment(CharSequence comment) throws IOException {
        this.writeComment0(comment);
        return this;
    }

    @Override
    public LDIFEntryWriter writeEntry(Entry entry) throws IOException {
        Reject.ifNull((Object)entry);
        if (this.isBranchExcluded(entry.getName())) {
            return this;
        }
        if (this.isEntryExcluded(entry)) {
            return this;
        }
        this.writeKeyAndValue((CharSequence)"dn", entry.getName().toString());
        TreeMap<String, AbstractMap.SimpleEntry<String, ByteString>> attr = new TreeMap<String, AbstractMap.SimpleEntry<String, ByteString>>();
        for (Attribute attribute : entry.getAllAttributes()) {
            if (this.isAttributeExcluded(attribute.getAttributeDescription())) continue;
            String attributeDescription = attribute.getAttributeDescriptionAsString();
            if (attribute.isEmpty()) {
                attr.put(attributeDescription, new AbstractMap.SimpleEntry<String, ByteString>(attributeDescription, ByteString.empty()));
                continue;
            }
            for (ByteString value : attribute) {
                attr.put(attributeDescription + value, new AbstractMap.SimpleEntry<String, ByteString>(attributeDescription, value));
            }
        }
        for (AbstractMap.SimpleEntry kv : attr.values()) {
            this.writeKeyAndValue((CharSequence)kv.getKey(), (ByteSequence)kv.getValue());
        }
        this.impl.println();
        return this;
    }
}

