/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.CoreSchemaImpl;
import org.forgerock.opendj.ldap.schema.DITContentRule;
import org.forgerock.opendj.ldap.schema.DITStructureRule;
import org.forgerock.opendj.ldap.schema.DelayedSchema;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;

public final class Schema {
    static final String ATTR_ATTRIBUTE_TYPES = "attributeTypes";
    static final String ATTR_DIT_CONTENT_RULES = "dITContentRules";
    static final String ATTR_DIT_STRUCTURE_RULES = "dITStructureRules";
    static final String ATTR_LDAP_SYNTAXES = "ldapSyntaxes";
    static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    static final String ATTR_MATCHING_RULES = "matchingRules";
    static final String ATTR_NAME_FORMS = "nameForms";
    static final String ATTR_OBJECT_CLASSES = "objectClasses";
    private final Impl impl;

    public static Schema getCoreSchema() {
        return CoreSchemaImpl.getInstance();
    }

    public static Schema getDefaultSchema() {
        return DelayedSchema.defaultSchema;
    }

    public static Schema getEmptySchema() {
        return DelayedSchema.EMPTY_SCHEMA;
    }

    public static Schema readSchema(Connection connection, DN name) throws LdapException {
        return new SchemaBuilder().addSchema(connection, name, true).toSchema();
    }

    public static LdapPromise<Schema> readSchemaAsync(Connection connection, DN name) {
        SchemaBuilder builder = new SchemaBuilder();
        return builder.addSchemaAsync(connection, name, true).then((Function)new Function<SchemaBuilder, Schema, LdapException>(){

            public Schema apply(SchemaBuilder builder) throws LdapException {
                return builder.toSchema();
            }
        });
    }

    public static Schema readSchemaForEntry(Connection connection, DN name) throws LdapException {
        return new SchemaBuilder().addSchemaForEntry(connection, name, true).toSchema();
    }

    public static LdapPromise<Schema> readSchemaForEntryAsync(Connection connection, DN name) {
        SchemaBuilder builder = new SchemaBuilder();
        return builder.addSchemaForEntryAsync(connection, name, true).then((Function)new Function<SchemaBuilder, Schema, LdapException>(){

            public Schema apply(SchemaBuilder builder) throws LdapException {
                return builder.toSchema();
            }
        });
    }

    public static void setDefaultSchema(Schema schema) {
        Reject.ifNull((Object)schema);
        DelayedSchema.defaultSchema = schema;
    }

    public static Schema valueOf(Entry entry) {
        return new SchemaBuilder(entry).toSchema();
    }

    Schema(Impl impl) {
        this.impl = impl;
    }

    public Schema asNonStrictSchema() {
        return this.impl.asNonStrictSchema();
    }

    public Schema asStrictSchema() {
        return this.impl.asStrictSchema();
    }

    MatchingRule getDefaultMatchingRule() {
        return this.impl.getDefaultMatchingRule();
    }

    Syntax getDefaultSyntax() {
        return this.impl.getDefaultSyntax();
    }

    public AttributeType getAttributeType(String nameOrOid) {
        return this.impl.getAttributeType(this, nameOrOid);
    }

    public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
        return this.impl.getAttributeType(nameOrOid, syntax);
    }

    public Collection<AttributeType> getAttributeTypes() {
        return this.impl.getAttributeTypes();
    }

    public DITContentRule getDITContentRule(ObjectClass structuralClass) {
        return this.impl.getDITContentRule(structuralClass);
    }

    public DITContentRule getDITContentRule(String nameOrOid) {
        return this.impl.getDITContentRule(nameOrOid);
    }

    public Collection<DITContentRule> getDITContentRules() {
        return this.impl.getDITContentRules();
    }

    public DITStructureRule getDITStructureRule(int ruleID) {
        return this.impl.getDITStructureRule(ruleID);
    }

    public DITStructureRule getDITStructureRule(String nameOrOid) {
        return this.impl.getDITStructureRule(nameOrOid);
    }

    public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
        return this.impl.getDITStructureRules(nameForm);
    }

    public Collection<DITStructureRule> getDITStuctureRules() {
        return this.impl.getDITStuctureRules();
    }

    public MatchingRule getMatchingRule(String nameOrOid) {
        return this.impl.getMatchingRule(nameOrOid);
    }

    public Collection<MatchingRule> getMatchingRules() {
        return this.impl.getMatchingRules();
    }

    public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return this.getMatchingRuleUse(matchingRule.getOID());
    }

    public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
        return this.impl.getMatchingRuleUse(nameOrOid);
    }

    public Collection<MatchingRuleUse> getMatchingRuleUses() {
        return this.impl.getMatchingRuleUses();
    }

    public NameForm getNameForm(String nameOrOid) {
        return this.impl.getNameForm(nameOrOid);
    }

    public Collection<NameForm> getNameForms() {
        return this.impl.getNameForms();
    }

    public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
        return this.impl.getNameForms(structuralClass);
    }

    public ObjectClass getObjectClass(String nameOrOid) {
        return this.impl.getObjectClass(nameOrOid);
    }

    public Collection<ObjectClass> getObjectClasses() {
        return this.impl.getObjectClasses();
    }

    public <T> T getOption(Option<T> option) {
        return (T)this.getOptions().get(option);
    }

    Options getOptions() {
        return this.impl.getOptions();
    }

    public String getSchemaName() {
        return this.impl.getSchemaName();
    }

    public Syntax getSyntax(String numericOID) {
        return this.impl.getSyntax(this, numericOID);
    }

    public Collection<Syntax> getSyntaxes() {
        return this.impl.getSyntaxes();
    }

    public Collection<LocalizableMessage> getWarnings() {
        return this.impl.getWarnings();
    }

    public boolean hasAttributeType(String nameOrOid) {
        return this.impl.hasAttributeType(nameOrOid);
    }

    public boolean hasDITContentRule(String nameOrOid) {
        return this.impl.hasDITContentRule(nameOrOid);
    }

    public boolean hasDITStructureRule(int ruleID) {
        return this.impl.hasDITStructureRule(ruleID);
    }

    public boolean hasMatchingRule(String nameOrOid) {
        return this.impl.hasMatchingRule(nameOrOid);
    }

    public boolean hasMatchingRuleUse(String nameOrOid) {
        return this.impl.hasMatchingRuleUse(nameOrOid);
    }

    public boolean hasNameForm(String nameOrOid) {
        return this.impl.hasNameForm(nameOrOid);
    }

    public boolean hasObjectClass(String nameOrOid) {
        return this.impl.hasObjectClass(nameOrOid);
    }

    public boolean hasSyntax(String numericOID) {
        return this.impl.hasSyntax(numericOID);
    }

    public boolean isStrict() {
        return this.impl.isStrict();
    }

    public Entry toEntry(Entry entry) {
        this.addAttribute(entry, ATTR_LDAP_SYNTAXES, this.getSyntaxes());
        this.addAttribute(entry, ATTR_ATTRIBUTE_TYPES, this.getAttributeTypes());
        this.addAttribute(entry, ATTR_OBJECT_CLASSES, this.getObjectClasses());
        this.addAttribute(entry, ATTR_MATCHING_RULE_USE, this.getMatchingRuleUses());
        this.addAttribute(entry, ATTR_MATCHING_RULES, this.getMatchingRules());
        this.addAttribute(entry, ATTR_DIT_CONTENT_RULES, this.getDITContentRules());
        this.addAttribute(entry, ATTR_DIT_STRUCTURE_RULES, this.getDITStuctureRules());
        this.addAttribute(entry, ATTR_NAME_FORMS, this.getNameForms());
        return entry;
    }

    private void addAttribute(Entry entry, String attrName, Collection<? extends SchemaElement> schemaElements) {
        LinkedAttribute attr = new LinkedAttribute(attrName);
        for (SchemaElement schemaElement : schemaElements) {
            attr.add(new Object[]{schemaElement.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
    }

    public boolean validateEntry(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        ObjectClass structuralObjectClass = null;
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        LinkedList<ObjectClass> objectClasses = new LinkedList<ObjectClass>();
        if (objectClassAttribute != null) {
            for (ByteString v : objectClassAttribute) {
                ObjectClass objectClass;
                String objectClassName = v.toString();
                try {
                    objectClass = this.asStrictSchema().getObjectClass(objectClassName);
                    objectClasses.add(objectClass);
                }
                catch (UnknownSchemaElementException e) {
                    if (!policy.checkAttributesAndObjectClasses().needsChecking()) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_UNKNOWN_OBJECT_CLASS.get((Object)entry.getName(), (Object)objectClassName));
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
                if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
                if (structuralObjectClass == null || objectClass.isDescendantOf(structuralObjectClass)) {
                    structuralObjectClass = objectClass;
                    continue;
                }
                if (structuralObjectClass.isDescendantOf(objectClass) || !policy.requireSingleStructuralObjectClass().needsChecking()) continue;
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_MULTIPLE_STRUCTURAL_CLASSES.get((Object)entry.getName(), (Object)structuralObjectClass.getNameOrOID(), (Object)objectClassName));
                }
                if (!policy.requireSingleStructuralObjectClass().isReject()) continue;
                return false;
            }
        }
        Collection<Object> ditStructureRules = Collections.emptyList();
        DITContentRule ditContentRule = null;
        if (structuralObjectClass == null) {
            if (policy.requireSingleStructuralObjectClass().needsChecking()) {
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_NO_STRUCTURAL_CLASS.get((Object)entry.getName()));
                }
                if (policy.requireSingleStructuralObjectClass().isReject()) {
                    return false;
                }
            }
        } else {
            ditContentRule = this.getDITContentRule(structuralObjectClass);
            if (ditContentRule != null && ditContentRule.isObsolete()) {
                ditContentRule = null;
            }
        }
        if (!this.checkAttributesAndObjectClasses(entry, policy, errorMessages, objectClasses, ditContentRule)) {
            return false;
        }
        if (policy.checkNameForms().needsChecking() && structuralObjectClass != null) {
            boolean foundMatchingNameForms = false;
            NameForm nameForm = null;
            LinkedList<LocalizableMessage> nameFormWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            for (NameForm nf : this.getNameForms(structuralObjectClass)) {
                if (nf.isObsolete()) continue;
                foundMatchingNameForms = true;
                if (!this.checkNameForm(entry, nameFormWarnings, nf)) continue;
                nameForm = nf;
                break;
            }
            if (foundMatchingNameForms) {
                if (nameForm != null) {
                    ditStructureRules = this.getDITStructureRules(nameForm);
                } else {
                    if (errorMessages != null) {
                        errorMessages.addAll(nameFormWarnings);
                    }
                    if (policy.checkNameForms().isReject()) {
                        return false;
                    }
                }
            }
        }
        if (policy.checkDITStructureRules().needsChecking() && !entry.getName().isRootDN()) {
            boolean foundMatchingRules = false;
            boolean foundValidRule = false;
            LinkedList<LocalizableMessage> ruleWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            ObjectClass parentStructuralObjectClass = null;
            boolean parentEntryHasBeenRead = false;
            for (DITStructureRule rule : ditStructureRules) {
                if (rule.isObsolete()) continue;
                foundMatchingRules = true;
                if (rule.getSuperiorRules().isEmpty()) {
                    foundValidRule = true;
                    break;
                }
                if (!parentEntryHasBeenRead) {
                    parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                    parentEntryHasBeenRead = true;
                }
                if (parentStructuralObjectClass == null || !this.checkDITStructureRule(entry, ruleWarnings, rule, structuralObjectClass, parentStructuralObjectClass)) continue;
                foundValidRule = true;
                break;
            }
            if (foundMatchingRules) {
                if (!foundValidRule) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDITStructureRules().isReject()) {
                        return false;
                    }
                }
            } else {
                parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                if (parentStructuralObjectClass == null) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDITStructureRules().isReject()) {
                        return false;
                    }
                } else {
                    for (NameForm nf : this.getNameForms(parentStructuralObjectClass)) {
                        if (nf.isObsolete()) continue;
                        for (DITStructureRule rule : this.getDITStructureRules(nf)) {
                            if (rule.isObsolete()) continue;
                            if (errorMessages != null) {
                                errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_MISSING_DSR.get((Object)entry.getName(), (Object)rule.getNameOrRuleID()));
                            }
                            if (!policy.checkDITStructureRules().isReject()) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean checkAttributesAndObjectClasses(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages, List<ObjectClass> objectClasses, DITContentRule ditContentRule) {
        boolean checkDITContentRule = policy.checkDITContentRules().needsChecking() && ditContentRule != null;
        boolean checkObjectClasses = policy.checkAttributesAndObjectClasses().needsChecking();
        boolean checkAttributeValues = policy.checkAttributeValues().needsChecking();
        if (checkObjectClasses || checkDITContentRule) {
            for (ObjectClass objectClass : objectClasses) {
                if (checkDITContentRule && objectClass.getObjectClassType() == ObjectClassType.AUXILIARY && !ditContentRule.getAuxiliaryClasses().contains(objectClass)) {
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_AUXILIARY_OC.get((Object)entry.getName(), (Object)objectClass.getNameOrOID(), (Object)ditContentRule.getNameOrOID()));
                    }
                    if (policy.checkDITContentRules().isReject()) {
                        return false;
                    }
                }
                if (!checkObjectClasses) continue;
                for (AttributeType t : objectClass.getDeclaredRequiredAttributes()) {
                    Attribute a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_OC_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)objectClass.getNameOrOID()));
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
            }
            if (checkDITContentRule) {
                Attribute a;
                for (AttributeType t : ditContentRule.getRequiredAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID()));
                    }
                    if (!policy.checkDITContentRules().isReject()) continue;
                    return false;
                }
                for (AttributeType t : ditContentRule.getProhibitedAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (!entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID()));
                    }
                    if (!policy.checkDITContentRules().isReject()) continue;
                    return false;
                }
            }
        }
        if (checkObjectClasses || checkDITContentRule || checkAttributeValues) {
            for (Attribute attribute : entry.getAllAttributes()) {
                AttributeType t = attribute.getAttributeDescription().getAttributeType();
                if (!t.isOperational() && (checkObjectClasses || checkDITContentRule)) {
                    boolean isAllowed = this.isRequiredOrOptional(objectClasses, t);
                    if (!isAllowed && ditContentRule != null && ditContentRule.isRequiredOrOptional(t)) {
                        isAllowed = true;
                    }
                    if (!isAllowed) {
                        if (errorMessages != null) {
                            LocalizableMessage message = ditContentRule != null ? CoreMessages.ERR_ENTRY_SCHEMA_DCR_DISALLOWED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID()) : CoreMessages.ERR_ENTRY_SCHEMA_OC_DISALLOWED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID());
                            errorMessages.add(message);
                        }
                        if (policy.checkAttributesAndObjectClasses().isReject() || policy.checkDITContentRules().isReject()) {
                            return false;
                        }
                    }
                }
                if (!checkAttributeValues) continue;
                int sz = attribute.size();
                if (sz == 0) {
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_AT_EMPTY_ATTRIBUTE.get((Object)entry.getName(), (Object)t.getNameOrOID()));
                    }
                    if (!policy.checkAttributeValues().isReject()) continue;
                    return false;
                }
                if (sz <= 1 || !t.isSingleValue()) continue;
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_AT_SINGLE_VALUED_ATTRIBUTE.get((Object)entry.getName(), (Object)t.getNameOrOID()));
                }
                if (!policy.checkAttributeValues().isReject()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isRequiredOrOptional(List<ObjectClass> objectClasses, AttributeType t) {
        for (ObjectClass objectClass : objectClasses) {
            if (!objectClass.isRequiredOrOptional(t)) continue;
            return true;
        }
        return false;
    }

    private boolean checkDITStructureRule(Entry entry, List<LocalizableMessage> ruleWarnings, DITStructureRule rule, ObjectClass structuralObjectClass, ObjectClass parentStructuralObjectClass) {
        boolean matchFound = false;
        for (DITStructureRule parentRule : rule.getSuperiorRules()) {
            if (!parentRule.getNameForm().getStructuralClass().equals(parentStructuralObjectClass)) continue;
            matchFound = true;
        }
        if (!matchFound) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_ILLEGAL_OC.get((Object)entry.getName(), (Object)rule.getNameOrRuleID(), (Object)structuralObjectClass.getNameOrOID(), (Object)parentStructuralObjectClass.getNameOrOID()));
            }
            return false;
        }
        return true;
    }

    private boolean checkNameForm(Entry entry, List<LocalizableMessage> nameFormWarnings, NameForm nameForm) {
        RDN rdn = entry.getName().rdn();
        if (rdn != null) {
            for (AttributeType t : nameForm.getRequiredAttributes()) {
                if (rdn.getAttributeValue(t) != null) continue;
                if (nameFormWarnings != null) {
                    nameFormWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_NF_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)nameForm.getNameOrOID()));
                }
                return false;
            }
            for (AVA ava : rdn) {
                AttributeType t = ava.getAttributeType();
                if (nameForm.isRequiredOrOptional(t)) continue;
                if (nameFormWarnings != null) {
                    nameFormWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_NF_DISALLOWED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)nameForm.getNameOrOID()));
                }
                return false;
            }
        }
        return true;
    }

    private ObjectClass getParentStructuralObjectClass(Entry entry, SchemaValidationPolicy policy, List<LocalizableMessage> ruleWarnings) {
        Entry parentEntry;
        try {
            parentEntry = policy.checkDITStructureRulesEntryResolver().getEntry(entry.getName().parent());
        }
        catch (LdapException e) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_PARENT_NOT_FOUND.get((Object)entry.getName(), (Object)e.getResult().getDiagnosticMessage()));
            }
            return null;
        }
        ObjectClass parentStructuralObjectClass = Entries.getStructuralObjectClass(parentEntry, this);
        if (parentStructuralObjectClass == null) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get((Object)entry.getName()));
            }
            return null;
        }
        return parentStructuralObjectClass;
    }

    public String toString() {
        return "Schema " + this.getSchemaName() + " mr=" + this.getMatchingRules().size() + " syntaxes=" + this.getSyntaxes().size() + " at=" + this.getAttributeTypes().size();
    }

    static final class StrictImpl
    implements Impl {
        private final Map<Integer, DITStructureRule> id2StructureRules;
        private final Map<String, AttributeType> name2AttributeTypes;
        private final Map<String, DITContentRule> name2ContentRules;
        private final Map<String, MatchingRule> name2MatchingRules;
        private final Map<String, MatchingRuleUse> name2MatchingRuleUses;
        private final Map<String, NameForm> name2NameForms;
        private final Map<String, ObjectClass> name2ObjectClasses;
        private final Map<String, DITStructureRule> name2StructureRules;
        private final Map<String, List<DITStructureRule>> nameForm2StructureRules;
        private final Map<String, AttributeType> numericOID2AttributeTypes;
        private final Map<String, DITContentRule> numericOID2ContentRules;
        private final Map<String, MatchingRule> numericOID2MatchingRules;
        private final Map<String, MatchingRuleUse> numericOID2MatchingRuleUses;
        private final Map<String, NameForm> numericOID2NameForms;
        private final Map<String, ObjectClass> numericOID2ObjectClasses;
        private final Map<String, Syntax> numericOID2Syntaxes;
        private final Map<String, List<NameForm>> objectClass2NameForms;
        private final List<LocalizableMessage> warnings;
        private final String schemaName;
        private final Options options;
        private final Syntax defaultSyntax;
        private final MatchingRule defaultMatchingRule;
        private final Schema strictSchema;
        private final Schema nonStrictSchema;

        StrictImpl(String schemaName, Options options, Syntax defaultSyntax, MatchingRule defaultMatchingRule, Map<String, Syntax> numericOID2Syntaxes, Map<String, MatchingRule> numericOID2MatchingRules, Map<String, MatchingRuleUse> numericOID2MatchingRuleUses, Map<String, AttributeType> numericOID2AttributeTypes, Map<String, ObjectClass> numericOID2ObjectClasses, Map<String, NameForm> numericOID2NameForms, Map<String, DITContentRule> numericOID2ContentRules, Map<Integer, DITStructureRule> id2StructureRules, Map<String, MatchingRule> name2MatchingRules, Map<String, MatchingRuleUse> name2MatchingRuleUses, Map<String, AttributeType> name2AttributeTypes, Map<String, ObjectClass> name2ObjectClasses, Map<String, NameForm> name2NameForms, Map<String, DITContentRule> name2ContentRules, Map<String, DITStructureRule> name2StructureRules, Map<String, List<NameForm>> objectClass2NameForms, Map<String, List<DITStructureRule>> nameForm2StructureRules, List<LocalizableMessage> warnings) {
            this.schemaName = schemaName;
            this.options = options;
            this.defaultSyntax = defaultSyntax;
            this.defaultMatchingRule = defaultMatchingRule;
            this.numericOID2Syntaxes = Collections.unmodifiableMap(numericOID2Syntaxes);
            this.numericOID2MatchingRules = Collections.unmodifiableMap(numericOID2MatchingRules);
            this.numericOID2MatchingRuleUses = Collections.unmodifiableMap(numericOID2MatchingRuleUses);
            this.numericOID2AttributeTypes = Collections.unmodifiableMap(numericOID2AttributeTypes);
            this.numericOID2ObjectClasses = Collections.unmodifiableMap(numericOID2ObjectClasses);
            this.numericOID2NameForms = Collections.unmodifiableMap(numericOID2NameForms);
            this.numericOID2ContentRules = Collections.unmodifiableMap(numericOID2ContentRules);
            this.id2StructureRules = Collections.unmodifiableMap(id2StructureRules);
            this.name2MatchingRules = Collections.unmodifiableMap(name2MatchingRules);
            this.name2MatchingRuleUses = Collections.unmodifiableMap(name2MatchingRuleUses);
            this.name2AttributeTypes = Collections.unmodifiableMap(name2AttributeTypes);
            this.name2ObjectClasses = Collections.unmodifiableMap(name2ObjectClasses);
            this.name2NameForms = Collections.unmodifiableMap(name2NameForms);
            this.name2ContentRules = Collections.unmodifiableMap(name2ContentRules);
            this.name2StructureRules = Collections.unmodifiableMap(name2StructureRules);
            this.objectClass2NameForms = Collections.unmodifiableMap(objectClass2NameForms);
            this.nameForm2StructureRules = Collections.unmodifiableMap(nameForm2StructureRules);
            this.warnings = Collections.unmodifiableList(warnings);
            this.strictSchema = new Schema(this);
            this.nonStrictSchema = new Schema(new NonStrictImpl(this));
        }

        @Override
        public Schema asNonStrictSchema() {
            return this.nonStrictSchema;
        }

        @Override
        public Schema asStrictSchema() {
            return this.strictSchema;
        }

        @Override
        public Options getOptions() {
            return this.options;
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.defaultSyntax;
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.defaultMatchingRule;
        }

        @Override
        public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
            return this.getAttributeType(null, nameOrOid);
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String nameOrOid) {
            AttributeType type = this.getAttributeType0(nameOrOid);
            if (type != null) {
                return type;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_ATTR_TYPE_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.numericOID2AttributeTypes.values();
        }

        @Override
        public DITContentRule getDITContentRule(ObjectClass structuralClass) {
            return this.numericOID2ContentRules.get(structuralClass.getOID());
        }

        @Override
        public DITContentRule getDITContentRule(String nameOrOid) {
            DITContentRule rule = this.numericOID2ContentRules.get(nameOrOid);
            if (rule != null) {
                return rule;
            }
            DITContentRule rule2 = this.name2ContentRules.get(StaticUtils.toLowerCase(nameOrOid));
            if (rule2 != null) {
                return rule2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_DCR_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<DITContentRule> getDITContentRules() {
            return this.numericOID2ContentRules.values();
        }

        @Override
        public DITStructureRule getDITStructureRule(int ruleID) {
            DITStructureRule rule = this.id2StructureRules.get(ruleID);
            if (rule == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_DSR_UNKNOWN.get((Object)String.valueOf(ruleID)));
            }
            return rule;
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
            List<DITStructureRule> rules = this.nameForm2StructureRules.get(nameForm.getOID());
            if (rules != null) {
                return rules;
            }
            return Collections.emptyList();
        }

        @Override
        public DITStructureRule getDITStructureRule(String name) {
            DITStructureRule rule = this.name2StructureRules.get(StaticUtils.toLowerCase(name));
            if (rule != null) {
                return rule;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_DIT_SR_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<DITStructureRule> getDITStuctureRules() {
            return this.id2StructureRules.values();
        }

        @Override
        public MatchingRule getMatchingRule(String nameOrOid) {
            MatchingRule rule = this.numericOID2MatchingRules.get(nameOrOid);
            if (rule != null) {
                return rule;
            }
            MatchingRule rule2 = this.name2MatchingRules.get(StaticUtils.toLowerCase(nameOrOid));
            if (rule2 != null) {
                return rule2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MR_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.numericOID2MatchingRules.values();
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.numericOID2MatchingRuleUses.get(matchingRule.getOID());
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
            MatchingRuleUse use = this.numericOID2MatchingRuleUses.get(nameOrOid);
            if (use != null) {
                return use;
            }
            MatchingRuleUse use2 = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(nameOrOid));
            if (use2 != null) {
                return use2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MRU_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.numericOID2MatchingRuleUses.values();
        }

        @Override
        public NameForm getNameForm(String nameOrOid) {
            NameForm form = this.numericOID2NameForms.get(nameOrOid);
            if (form != null) {
                return form;
            }
            NameForm form2 = this.name2NameForms.get(StaticUtils.toLowerCase(nameOrOid));
            if (form2 != null) {
                return form2;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_NAMEFORM_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.numericOID2NameForms.values();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            List<NameForm> forms = this.objectClass2NameForms.get(structuralClass.getOID());
            if (forms != null) {
                return forms;
            }
            return Collections.emptyList();
        }

        @Override
        public ObjectClass getObjectClass(String nameOrOid) {
            ObjectClass result = this.getObjectClass0(nameOrOid);
            if (result != null) {
                return result;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_OBJECTCLASS_UNKNOWN.get((Object)nameOrOid));
        }

        private ObjectClass getObjectClass0(String nameOrOid) {
            ObjectClass oc = this.numericOID2ObjectClasses.get(nameOrOid);
            if (oc != null) {
                return oc;
            }
            ObjectClass oc2 = this.name2ObjectClasses.get(StaticUtils.toLowerCase(nameOrOid));
            if (oc2 != null) {
                return oc2;
            }
            return null;
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.numericOID2ObjectClasses.values();
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOID) {
            Syntax syntax = this.numericOID2Syntaxes.get(numericOID);
            if (syntax == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_SYNTAX_UNKNOWN.get((Object)numericOID));
            }
            return syntax;
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.numericOID2Syntaxes.values();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.warnings;
        }

        @Override
        public boolean hasAttributeType(String nameOrOid) {
            return this.numericOID2AttributeTypes.containsKey(nameOrOid) || this.name2AttributeTypes.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasDITContentRule(String nameOrOid) {
            return this.numericOID2ContentRules.containsKey(nameOrOid) || this.name2ContentRules.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasDITStructureRule(int ruleID) {
            return this.id2StructureRules.containsKey(ruleID);
        }

        @Override
        public boolean hasMatchingRule(String nameOrOid) {
            return this.numericOID2MatchingRules.containsKey(nameOrOid) || this.name2MatchingRules.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasMatchingRuleUse(String nameOrOid) {
            return this.numericOID2MatchingRuleUses.containsKey(nameOrOid) || this.name2MatchingRuleUses.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasNameForm(String nameOrOid) {
            return this.numericOID2NameForms.containsKey(nameOrOid) || this.name2NameForms.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasObjectClass(String nameOrOid) {
            return this.numericOID2ObjectClasses.containsKey(nameOrOid) || this.name2ObjectClasses.containsKey(StaticUtils.toLowerCase(nameOrOid));
        }

        @Override
        public boolean hasSyntax(String numericOID) {
            return this.numericOID2Syntaxes.containsKey(numericOID);
        }

        @Override
        public boolean isStrict() {
            return true;
        }

        AttributeType getAttributeType0(String nameOrOid) {
            AttributeType type = this.numericOID2AttributeTypes.get(nameOrOid);
            if (type != null) {
                return type;
            }
            return this.name2AttributeTypes.get(StaticUtils.toLowerCase(nameOrOid));
        }
    }

    private static final class NonStrictImpl
    implements Impl {
        private final StrictImpl strictImpl;

        private NonStrictImpl(StrictImpl strictImpl) {
            this.strictImpl = strictImpl;
        }

        @Override
        public Schema asNonStrictSchema() {
            return this.strictImpl.asNonStrictSchema();
        }

        @Override
        public Schema asStrictSchema() {
            return this.strictImpl.asStrictSchema();
        }

        @Override
        public Options getOptions() {
            return this.strictImpl.getOptions();
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.strictImpl.getDefaultSyntax();
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.strictImpl.getDefaultMatchingRule();
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String nameOrOid) {
            return this.getAttributeType0(nameOrOid, schema.getDefaultSyntax(), schema.getDefaultMatchingRule());
        }

        @Override
        public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
            return this.getAttributeType0(nameOrOid, syntax, syntax.getEqualityMatchingRule());
        }

        private AttributeType getAttributeType0(String nameOrOid, Syntax syntax, MatchingRule equalityMatchingRule) {
            AttributeType type = this.strictImpl.getAttributeType0(nameOrOid);
            return type != null ? type : AttributeType.newPlaceHolder(nameOrOid, syntax, equalityMatchingRule);
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.strictImpl.getAttributeTypes();
        }

        @Override
        public DITContentRule getDITContentRule(ObjectClass structuralClass) {
            return this.strictImpl.getDITContentRule(structuralClass);
        }

        @Override
        public DITContentRule getDITContentRule(String nameOrOid) {
            return this.strictImpl.getDITContentRule(nameOrOid);
        }

        @Override
        public Collection<DITContentRule> getDITContentRules() {
            return this.strictImpl.getDITContentRules();
        }

        @Override
        public DITStructureRule getDITStructureRule(int ruleID) {
            return this.strictImpl.getDITStructureRule(ruleID);
        }

        @Override
        public DITStructureRule getDITStructureRule(String name) {
            return this.strictImpl.getDITStructureRule(name);
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
            return this.strictImpl.getDITStructureRules(nameForm);
        }

        @Override
        public Collection<DITStructureRule> getDITStuctureRules() {
            return this.strictImpl.getDITStuctureRules();
        }

        @Override
        public MatchingRule getMatchingRule(String nameOrOid) {
            return this.strictImpl.getMatchingRule(nameOrOid);
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.strictImpl.getMatchingRules();
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.strictImpl.getMatchingRuleUse(matchingRule);
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
            return this.strictImpl.getMatchingRuleUse(nameOrOid);
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.strictImpl.getMatchingRuleUses();
        }

        @Override
        public NameForm getNameForm(String nameOrOid) {
            return this.strictImpl.getNameForm(nameOrOid);
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.strictImpl.getNameForms();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            return this.strictImpl.getNameForms(structuralClass);
        }

        @Override
        public ObjectClass getObjectClass(String nameOrOid) {
            ObjectClass result = this.strictImpl.getObjectClass0(nameOrOid);
            return result != null ? result : ObjectClass.newPlaceHolder(nameOrOid);
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.strictImpl.getObjectClasses();
        }

        @Override
        public String getSchemaName() {
            return this.strictImpl.getSchemaName();
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOID) {
            if (!this.strictImpl.hasSyntax(numericOID)) {
                return new Syntax(schema, numericOID);
            }
            return this.strictImpl.getSyntax(schema, numericOID);
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.strictImpl.getSyntaxes();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.strictImpl.getWarnings();
        }

        @Override
        public boolean hasAttributeType(String nameOrOid) {
            return this.strictImpl.hasAttributeType(nameOrOid);
        }

        @Override
        public boolean hasDITContentRule(String nameOrOid) {
            return this.strictImpl.hasDITContentRule(nameOrOid);
        }

        @Override
        public boolean hasDITStructureRule(int ruleID) {
            return this.strictImpl.hasDITStructureRule(ruleID);
        }

        @Override
        public boolean hasMatchingRule(String nameOrOid) {
            return this.strictImpl.hasMatchingRule(nameOrOid);
        }

        @Override
        public boolean hasMatchingRuleUse(String nameOrOid) {
            return this.strictImpl.hasMatchingRuleUse(nameOrOid);
        }

        @Override
        public boolean hasNameForm(String nameOrOid) {
            return this.strictImpl.hasNameForm(nameOrOid);
        }

        @Override
        public boolean hasObjectClass(String nameOrOid) {
            return this.strictImpl.hasObjectClass(nameOrOid);
        }

        @Override
        public boolean hasSyntax(String numericOID) {
            return this.strictImpl.hasSyntax(numericOID);
        }

        @Override
        public boolean isStrict() {
            return false;
        }
    }

    private static interface Impl {
        public Schema asNonStrictSchema();

        public Schema asStrictSchema();

        public Options getOptions();

        public MatchingRule getDefaultMatchingRule();

        public Syntax getDefaultSyntax();

        public AttributeType getAttributeType(Schema var1, String var2);

        public AttributeType getAttributeType(String var1, Syntax var2);

        public Collection<AttributeType> getAttributeTypes();

        public DITContentRule getDITContentRule(ObjectClass var1);

        public DITContentRule getDITContentRule(String var1);

        public Collection<DITContentRule> getDITContentRules();

        public DITStructureRule getDITStructureRule(int var1);

        public DITStructureRule getDITStructureRule(String var1);

        public Collection<DITStructureRule> getDITStructureRules(NameForm var1);

        public Collection<DITStructureRule> getDITStuctureRules();

        public MatchingRule getMatchingRule(String var1);

        public Collection<MatchingRule> getMatchingRules();

        public MatchingRuleUse getMatchingRuleUse(MatchingRule var1);

        public MatchingRuleUse getMatchingRuleUse(String var1);

        public Collection<MatchingRuleUse> getMatchingRuleUses();

        public NameForm getNameForm(String var1);

        public Collection<NameForm> getNameForms();

        public Collection<NameForm> getNameForms(ObjectClass var1);

        public ObjectClass getObjectClass(String var1);

        public Collection<ObjectClass> getObjectClasses();

        public String getSchemaName();

        public Syntax getSyntax(Schema var1, String var2);

        public Collection<Syntax> getSyntaxes();

        public Collection<LocalizableMessage> getWarnings();

        public boolean hasAttributeType(String var1);

        public boolean hasDITContentRule(String var1);

        public boolean hasDITStructureRule(int var1);

        public boolean hasMatchingRule(String var1);

        public boolean hasMatchingRuleUse(String var1);

        public boolean hasNameForm(String var1);

        public boolean hasObjectClass(String var1);

        public boolean hasSyntax(String var1);

        public boolean isStrict();
    }
}

