/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class DITContentRule
extends AbstractSchemaElement {
    private final String structuralClassOID;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> auxiliaryClassOIDs;
    private final Set<String> optionalAttributeOIDs;
    private final Set<String> prohibitedAttributeOIDs;
    private final Set<String> requiredAttributeOIDs;
    private ObjectClass structuralClass;
    private Set<ObjectClass> auxiliaryClasses = Collections.emptySet();
    private Set<AttributeType> optionalAttributes = Collections.emptySet();
    private Set<AttributeType> prohibitedAttributes = Collections.emptySet();
    private Set<AttributeType> requiredAttributes = Collections.emptySet();

    private DITContentRule(Builder builder) {
        super(builder);
        Reject.ifNull((Object)builder.structuralClassOID);
        this.structuralClassOID = builder.structuralClassOID;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.isObsolete = builder.isObsolete;
        this.auxiliaryClassOIDs = SchemaUtils.unmodifiableCopyOfSet(builder.auxiliaryClassOIDs);
        this.optionalAttributeOIDs = SchemaUtils.unmodifiableCopyOfSet(builder.optionalAttributeOIDs);
        this.prohibitedAttributeOIDs = SchemaUtils.unmodifiableCopyOfSet(builder.prohibitedAttributeOIDs);
        this.requiredAttributeOIDs = SchemaUtils.unmodifiableCopyOfSet(builder.requiredAttributeOIDs);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DITContentRule) {
            DITContentRule other = (DITContentRule)o;
            return this.structuralClassOID.equals(other.structuralClassOID);
        }
        return false;
    }

    public Set<ObjectClass> getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.structuralClassOID;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getProhibitedAttributes() {
        return this.prohibitedAttributes;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public ObjectClass getStructuralClass() {
        return this.structuralClass;
    }

    public String getStructuralClassOID() {
        return this.structuralClassOID;
    }

    @Override
    public int hashCode() {
        return this.structuralClassOID.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.structuralClassOID.equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.structuralClassOID);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.auxiliaryClassOIDs.isEmpty()) {
            iterator = this.auxiliaryClassOIDs.iterator();
            String firstClass = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" AUX (");
                buffer.append(firstClass);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" AUX ");
                buffer.append(firstClass);
            }
        }
        if (!this.requiredAttributeOIDs.isEmpty()) {
            iterator = this.requiredAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributeOIDs.isEmpty()) {
            iterator = this.optionalAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
        if (!this.prohibitedAttributeOIDs.isEmpty()) {
            iterator = this.prohibitedAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NOT ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" NOT ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        if (this.structuralClassOID != null) {
            try {
                this.structuralClass = schema.getObjectClass(this.structuralClassOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_STRUCTURAL_CLASS1.get((Object)this.getNameOrOID(), (Object)this.structuralClassOID);
                throw new SchemaException(message, (Throwable)((Object)e));
            }
            if (this.structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_STRUCTURAL_CLASS_NOT_STRUCTURAL1.get((Object)this.getNameOrOID(), (Object)this.structuralClass.getNameOrOID(), (Object)this.structuralClass.getObjectClassType().toString());
                warnings.add(message);
            }
            if (!this.isObsolete() && this.structuralClass.isObsolete()) {
                warnings.add(CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_STRUCTURAL_CLASS.get((Object)this.getNameOrOID(), (Object)this.structuralClassOID));
            }
        }
        if (!this.auxiliaryClassOIDs.isEmpty()) {
            this.auxiliaryClasses = new HashSet<ObjectClass>(this.auxiliaryClassOIDs.size());
            for (String oid : this.auxiliaryClassOIDs) {
                ObjectClass objectClass;
                try {
                    objectClass = schema.getObjectClass(oid);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_AUXILIARY_CLASS1.get((Object)this.getNameOrOID(), (Object)oid);
                    throw new SchemaException(message, (Throwable)((Object)e));
                }
                if (objectClass.getObjectClassType() != ObjectClassType.AUXILIARY) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_AUXILIARY_CLASS_NOT_AUXILIARY1.get((Object)this.getNameOrOID(), (Object)this.structuralClass.getOID(), (Object)this.structuralClass.getObjectClassType().toString());
                    throw new SchemaException(message);
                }
                if (!this.isObsolete() && objectClass.isObsolete()) {
                    warnings.add(CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_AUXILIARY_CLASS.get((Object)this.getNameOrOID(), (Object)oid));
                }
                this.auxiliaryClasses.add(objectClass);
            }
        }
        if (!this.requiredAttributeOIDs.isEmpty()) {
            this.requiredAttributes = this.getAttributeTypes(schema, this.requiredAttributeOIDs, CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_REQUIRED_ATTR1, warnings, CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_REQUIRED_ATTR);
        }
        if (!this.optionalAttributeOIDs.isEmpty()) {
            this.optionalAttributes = this.getAttributeTypes(schema, this.optionalAttributeOIDs, CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_OPTIONAL_ATTR1, warnings, CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_OPTIONAL_ATTR);
        }
        if (!this.prohibitedAttributeOIDs.isEmpty()) {
            this.prohibitedAttributes = this.getAttributeTypes(schema, this.prohibitedAttributeOIDs, CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_PROHIBITED_ATTR1, warnings, CoreMessages.WARN_DIT_CR_HAS_OBSOLETE_PROHIBITED_ATTR);
        }
        for (AttributeType t : this.prohibitedAttributes) {
            if (this.structuralClass.isRequired(t)) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_STRUCTURAL.get((Object)this.getNameOrOID(), (Object)t.getNameOrOID(), (Object)this.structuralClass.getNameOrOID());
                throw new SchemaException(message);
            }
            for (ObjectClass oc : this.auxiliaryClasses) {
                if (!oc.isRequired(t)) continue;
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_AUXILIARY.get((Object)this.getNameOrOID(), (Object)t.getNameOrOID(), (Object)oc.getNameOrOID());
                throw new SchemaException(message);
            }
        }
        this.auxiliaryClasses = Collections.unmodifiableSet(this.auxiliaryClasses);
        this.optionalAttributes = Collections.unmodifiableSet(this.optionalAttributes);
        this.prohibitedAttributes = Collections.unmodifiableSet(this.prohibitedAttributes);
        this.requiredAttributes = Collections.unmodifiableSet(this.requiredAttributes);
    }

    private Set<AttributeType> getAttributeTypes(Schema schema, Set<String> oids, LocalizableMessageDescriptor.Arg2<Object, Object> unkwownElementErrorMsg, List<LocalizableMessage> warnings, LocalizableMessageDescriptor.Arg2<Object, Object> obsoleteElementWarningMsg) throws SchemaException {
        HashSet<AttributeType> attrTypes = new HashSet<AttributeType>(oids.size());
        for (String oid : oids) {
            AttributeType attributeType;
            try {
                attributeType = schema.getAttributeType(oid);
                attrTypes.add(attributeType);
            }
            catch (UnknownSchemaElementException e) {
                throw new SchemaException(unkwownElementErrorMsg.get((Object)this.getNameOrOID(), (Object)oid), (Throwable)((Object)e));
            }
            if (this.isObsolete() || !attributeType.isObsolete()) continue;
            warnings.add(obsoleteElementWarningMsg.get((Object)this.getNameOrOID(), (Object)oid));
        }
        return attrTypes;
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private String structuralClassOID;
        private final List<String> names = new LinkedList<String>();
        private boolean isObsolete;
        private final Set<String> auxiliaryClassOIDs = new LinkedHashSet<String>();
        private final Set<String> optionalAttributeOIDs = new LinkedHashSet<String>();
        private final Set<String> prohibitedAttributeOIDs = new LinkedHashSet<String>();
        private final Set<String> requiredAttributeOIDs = new LinkedHashSet<String>();

        Builder(DITContentRule contentRule, SchemaBuilder schemaBuilder) {
            super(schemaBuilder, contentRule);
            this.structuralClassOID = contentRule.structuralClassOID;
            this.names.addAll(contentRule.getNames());
            this.isObsolete = contentRule.isObsolete;
            this.auxiliaryClassOIDs.addAll(contentRule.auxiliaryClassOIDs);
            this.optionalAttributeOIDs.addAll(contentRule.optionalAttributeOIDs);
            this.prohibitedAttributeOIDs.addAll(contentRule.prohibitedAttributeOIDs);
            this.requiredAttributeOIDs.addAll(contentRule.requiredAttributeOIDs);
        }

        Builder(String structuralClassOID, SchemaBuilder builder) {
            super(builder);
            this.structuralClassOID = structuralClassOID;
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addDITContentRule(new DITContentRule(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addDITContentRule(new DITContentRule(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        public Builder auxiliaryObjectClasses(Collection<String> objectClassNamesOrOIDs) {
            this.auxiliaryClassOIDs.addAll(objectClassNamesOrOIDs);
            return this;
        }

        public Builder auxiliaryObjectClasses(String ... objectClassNamesOrOIDs) {
            this.auxiliaryClassOIDs.addAll(Arrays.asList(objectClassNamesOrOIDs));
            return this;
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder optionalAttributes(Collection<String> attributeNamesOrOIDs) {
            this.optionalAttributeOIDs.addAll(attributeNamesOrOIDs);
            return this;
        }

        public Builder optionalAttributes(String ... attributeNamesOrOIDs) {
            this.optionalAttributeOIDs.addAll(Arrays.asList(attributeNamesOrOIDs));
            return this;
        }

        public Builder prohibitedAttributes(Collection<String> attributeNamesOrOIDs) {
            this.prohibitedAttributeOIDs.addAll(attributeNamesOrOIDs);
            return this;
        }

        public Builder prohibitedAttributes(String ... attributeNamesOrOIDs) {
            this.prohibitedAttributeOIDs.addAll(Arrays.asList(attributeNamesOrOIDs));
            return this;
        }

        public Builder removeAllAuxiliaryObjectClasses() {
            this.auxiliaryClassOIDs.clear();
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        public Builder removeAllOptionalAttributes() {
            this.optionalAttributeOIDs.clear();
            return this;
        }

        public Builder removeAllProhibitedAttributes() {
            this.prohibitedAttributeOIDs.clear();
            return this;
        }

        public Builder removeAllRequiredAttributes() {
            this.requiredAttributeOIDs.clear();
            return this;
        }

        public Builder removeAuxiliaryObjectClass(String objectClassNameOrOID) {
            this.auxiliaryClassOIDs.remove(objectClassNameOrOID);
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }

        public Builder removeOptionalAttribute(String attributeNameOrOID) {
            this.optionalAttributeOIDs.remove(attributeNameOrOID);
            return this;
        }

        public Builder removeProhibitedAttribute(String attributeNameOrOID) {
            this.prohibitedAttributeOIDs.remove(attributeNameOrOID);
            return this;
        }

        public Builder removeRequiredAttribute(String attributeNameOrOID) {
            this.requiredAttributeOIDs.remove(attributeNameOrOID);
            return this;
        }

        public Builder requiredAttributes(Collection<String> attributeNamesOrOIDs) {
            this.requiredAttributeOIDs.addAll(attributeNamesOrOIDs);
            return this;
        }

        public Builder requiredAttributes(String ... attributeNamesOrOIDs) {
            this.requiredAttributeOIDs.addAll(Arrays.asList(attributeNamesOrOIDs));
            return this;
        }

        public Builder structuralClassOID(String strucuralClassOID) {
            this.structuralClassOID = strucuralClassOID;
            return this;
        }
    }
}

