/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class AuthPasswordSyntaxImpl
extends AbstractSyntaxImpl {
    AuthPasswordSyntaxImpl() {
    }

    static String[] decodeAuthPassword(String authPasswordValue) throws DecodeException {
        int length = authPasswordValue.length();
        int pos = 0;
        pos = AuthPasswordSyntaxImpl.readSpaces(authPasswordValue, pos);
        StringBuilder scheme = new StringBuilder();
        pos = AuthPasswordSyntaxImpl.readScheme(authPasswordValue, scheme, pos);
        if (scheme.length() == 0) {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME.get());
        }
        pos = AuthPasswordSyntaxImpl.readSpaces(authPasswordValue, pos);
        AuthPasswordSyntaxImpl.throwIfEndReached(authPasswordValue, length, pos, CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME_SEPARATOR);
        ++pos;
        pos = AuthPasswordSyntaxImpl.readSpaces(authPasswordValue, pos);
        StringBuilder authInfo = new StringBuilder();
        pos = AuthPasswordSyntaxImpl.readAuthInfo(authPasswordValue, authInfo, pos);
        if (authInfo.length() == 0) {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO.get());
        }
        pos = AuthPasswordSyntaxImpl.readSpaces(authPasswordValue, pos);
        AuthPasswordSyntaxImpl.throwIfEndReached(authPasswordValue, length, pos, CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO_SEPARATOR);
        ++pos;
        pos = AuthPasswordSyntaxImpl.readSpaces(authPasswordValue, pos);
        StringBuilder authValue = new StringBuilder();
        if (authValue.length() == 0) {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_VALUE.get());
        }
        for (pos = AuthPasswordSyntaxImpl.readAuthValue(authPasswordValue, length, pos, authValue); pos < length; ++pos) {
            char c = authPasswordValue.charAt(pos);
            if (c == ' ') {
                continue;
            }
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_TRAILING_CHAR.get((Object)pos));
        }
        return new String[]{scheme.toString(), authInfo.toString(), authValue.toString()};
    }

    private static int readAuthValue(String authPasswordValue, int length, int pos, StringBuilder authValue) throws DecodeException {
        char c;
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
                authValue.append(c);
                ++pos;
                continue;
            }
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_VALUE_CHAR.get((Object)pos));
        }
        return pos;
    }

    private static void throwIfEndReached(String authPasswordValue, int length, int pos, LocalizableMessageDescriptor.Arg0 message) throws DecodeException {
        if (pos >= length || authPasswordValue.charAt(pos) != '$') {
            throw DecodeException.error(message.get());
        }
    }

    private static int readAuthInfo(String authPasswordValue, StringBuilder authInfo, int pos) throws DecodeException {
        char c;
        int length = authPasswordValue.length();
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
                authInfo.append(c);
                ++pos;
                continue;
            }
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_INFO_CHAR.get((Object)pos));
        }
        return pos;
    }

    private static int readSpaces(String authPasswordValue, int pos) {
        int length = authPasswordValue.length();
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        return pos;
    }

    private static int readScheme(String authPasswordValue, StringBuilder scheme, int pos) throws DecodeException {
        int length = authPasswordValue.length();
        block4: while (pos < length) {
            char c = authPasswordValue.charAt(pos);
            switch (c) {
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': {
                    scheme.append(c);
                    ++pos;
                    continue block4;
                }
                case ' ': 
                case '$': {
                    return pos;
                }
            }
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_SCHEME_CHAR.get((Object)pos));
        }
        return pos;
    }

    static boolean isEncoded(ByteSequence value) {
        try {
            AuthPasswordSyntaxImpl.decodeAuthPassword(value.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getEqualityMatchingRule() {
        return "1.3.6.1.4.1.4203.1.2.2";
    }

    @Override
    public String getName() {
        return "AuthenticationPasswordSyntax";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        try {
            AuthPasswordSyntaxImpl.decodeAuthPassword(value.toString());
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }
}

