/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.sun.security.auth.callback.TextCallbackHandler;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AbstractSASLBindRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.GSSAPISASLBindRequest;
import org.forgerock.opendj.ldap.requests.SASLBindClientImpl;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;

final class GSSAPISASLBindRequestImpl
extends AbstractSASLBindRequest<GSSAPISASLBindRequest>
implements GSSAPISASLBindRequest {
    private final Map<String, String> additionalAuthParams = new LinkedHashMap<String, String>();
    private String authenticationID;
    private String authorizationID;
    private String kdcAddress;
    private Integer maxReceiveBufferSize;
    private Integer maxSendBufferSize;
    private byte[] password;
    private final List<String> qopValues = new LinkedList<String>();
    private String realm;
    private Boolean serverAuth;
    private Subject subject;

    GSSAPISASLBindRequestImpl(GSSAPISASLBindRequest gssapiSASLBindRequest) {
        super(gssapiSASLBindRequest);
        this.subject = gssapiSASLBindRequest.getSubject();
        this.authenticationID = gssapiSASLBindRequest.getAuthenticationID();
        this.password = StaticUtils.copyOfBytes(gssapiSASLBindRequest.getPassword());
        this.realm = gssapiSASLBindRequest.getRealm();
        this.kdcAddress = gssapiSASLBindRequest.getKDCAddress();
        this.authorizationID = gssapiSASLBindRequest.getAuthorizationID();
        this.additionalAuthParams.putAll(gssapiSASLBindRequest.getAdditionalAuthParams());
        this.qopValues.addAll(gssapiSASLBindRequest.getQOPs());
        this.serverAuth = gssapiSASLBindRequest.isServerAuth();
        this.maxReceiveBufferSize = gssapiSASLBindRequest.getMaxReceiveBufferSize();
        this.maxSendBufferSize = gssapiSASLBindRequest.getMaxSendBufferSize();
    }

    GSSAPISASLBindRequestImpl(String authenticationID, byte[] password) {
        Reject.ifNull((Object[])new Serializable[]{authenticationID, password});
        this.authenticationID = authenticationID;
        this.password = password;
    }

    GSSAPISASLBindRequestImpl(Subject subject) {
        Reject.ifNull((Object)subject);
        this.subject = subject;
    }

    @Override
    public GSSAPISASLBindRequest addAdditionalAuthParam(String name, String value) {
        Reject.ifNull((Object)name, (String)value);
        this.additionalAuthParams.put(name, value);
        return this;
    }

    @Override
    public GSSAPISASLBindRequest addQOP(String ... qopValues) {
        for (String qopValue : qopValues) {
            this.qopValues.add((String)Reject.checkNotNull((Object)qopValue));
        }
        return this;
    }

    @Override
    public BindClient createBindClient(String serverName) throws LdapException {
        return new Client(this, serverName);
    }

    @Override
    public Map<String, String> getAdditionalAuthParams() {
        return this.additionalAuthParams;
    }

    @Override
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public String getKDCAddress() {
        return this.kdcAddress;
    }

    @Override
    public int getMaxReceiveBufferSize() {
        return this.maxReceiveBufferSize == null ? 65536 : this.maxReceiveBufferSize;
    }

    @Override
    public int getMaxSendBufferSize() {
        return this.maxSendBufferSize == null ? 65536 : this.maxSendBufferSize;
    }

    @Override
    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public List<String> getQOPs() {
        return this.qopValues;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getSASLMechanism() {
        return "GSSAPI";
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public boolean isServerAuth() {
        return this.serverAuth == null ? false : this.serverAuth;
    }

    @Override
    public GSSAPISASLBindRequest setAuthenticationID(String authenticationID) {
        Reject.ifNull((Object)authenticationID);
        this.authenticationID = authenticationID;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setKDCAddress(String address) {
        this.kdcAddress = address;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setMaxReceiveBufferSize(int size) {
        this.maxReceiveBufferSize = size;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setMaxSendBufferSize(int size) {
        this.maxSendBufferSize = size;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setPassword(byte[] password) {
        Reject.ifNull((Object)password);
        this.password = password;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setPassword(char[] password) {
        Reject.ifNull((Object)password);
        this.password = StaticUtils.getBytes(password);
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setServerAuth(boolean serverAuth) {
        this.serverAuth = serverAuth;
        return this;
    }

    @Override
    public GSSAPISASLBindRequest setSubject(Subject subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GSSAPISASLBindRequest(bindDN=");
        builder.append(this.getName());
        builder.append(", authentication=SASL");
        builder.append(", saslMechanism=");
        builder.append(this.getSASLMechanism());
        if (this.subject != null) {
            builder.append(", subject=");
            builder.append(this.subject);
        } else {
            builder.append(", authenticationID=");
            builder.append(this.authenticationID);
            builder.append(", authorizationID=");
            builder.append(this.authorizationID);
            builder.append(", realm=");
            builder.append(this.realm);
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class Client
    extends SASLBindClientImpl {
        private final String authorizationID;
        private final PrivilegedExceptionAction<Boolean> evaluateAction = new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws LdapException {
                return this.evaluateSaslBindResult(saslClient, lastResult);
            }
        };
        private BindResult lastResult;
        private final SaslClient saslClient;
        private final Subject subject;

        private static Subject kerberos5Login(String authenticationID, ByteString password, String realm, String kdc) throws LdapException {
            if (authenticationID == null) {
                throw LdapException.newLdapException(Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setDiagnosticMessage("No authentication ID specified for GSSAPI SASL authentication"));
            }
            if (password == null) {
                throw LdapException.newLdapException(Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setDiagnosticMessage("No password specified for GSSAPI SASL authentication"));
            }
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("javax.security.auth.login.name", authenticationID);
            state.put("javax.security.auth.login.password", password.toString().toCharArray());
            state.put("javax.security.auth.useSubjectCredsOnly", "true");
            state.put("java.security.krb5.realm", realm);
            state.put("java.security.krb5.kdc", kdc);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("tryFirstPass", "true");
            options.put("useTicketCache", "true");
            options.put("doNotPrompt", "true");
            options.put("storePass", "false");
            options.put("forwardable", "true");
            Subject subject = new Subject();
            Krb5LoginModule login = new Krb5LoginModule();
            login.initialize(subject, new TextCallbackHandler(), state, options);
            try {
                if (login.login()) {
                    login.commit();
                }
            }
            catch (LoginException e) {
                LocalizableMessage message = CoreMessages.ERR_LDAPAUTH_GSSAPI_LOCAL_AUTHENTICATION_FAILED.get((Object)StaticUtils.getExceptionMessage(e));
                throw LdapException.newLdapException(Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setDiagnosticMessage(message.toString()).setCause(e));
            }
            return subject;
        }

        private Client(final GSSAPISASLBindRequestImpl initialBindRequest, final String serverName) throws LdapException {
            super(initialBindRequest);
            this.authorizationID = initialBindRequest.getAuthorizationID();
            this.subject = initialBindRequest.getSubject() != null ? initialBindRequest.getSubject() : Client.kerberos5Login(initialBindRequest.getAuthenticationID(), ByteString.wrap(initialBindRequest.getPassword()), initialBindRequest.getRealm(), initialBindRequest.getKDCAddress());
            try {
                this.saslClient = Subject.doAs(this.subject, new PrivilegedExceptionAction<SaslClient>(){

                    @Override
                    public SaslClient run() throws LdapException {
                        Integer size;
                        Boolean serverAuth;
                        HashMap<String, String> props = new HashMap<String, String>();
                        List<String> qopValues = initialBindRequest.getQOPs();
                        if (!qopValues.isEmpty()) {
                            props.put("javax.security.sasl.qop", Utils.joinAsString((String)",", qopValues));
                        }
                        if ((serverAuth = Boolean.valueOf(initialBindRequest.isServerAuth())) != null) {
                            props.put("javax.security.sasl.server.authentication", String.valueOf(serverAuth));
                        }
                        if ((size = Integer.valueOf(initialBindRequest.getMaxReceiveBufferSize())) != null) {
                            props.put("javax.security.sasl.maxbuffer", String.valueOf(size));
                        }
                        if ((size = Integer.valueOf(initialBindRequest.getMaxSendBufferSize())) != null) {
                            props.put("javax.security.sasl.sendmaxbuffer", String.valueOf(size));
                        }
                        for (Map.Entry<String, String> e : initialBindRequest.getAdditionalAuthParams().entrySet()) {
                            props.put(e.getKey(), e.getValue());
                        }
                        try {
                            SaslClient saslClient = Sasl.createSaslClient(new String[]{"GSSAPI"}, authorizationID, "ldap", serverName, props, this);
                            if (saslClient.hasInitialResponse()) {
                                this.setNextSASLCredentials(saslClient.evaluateChallenge(new byte[0]));
                            } else {
                                this.setNextSASLCredentials((ByteString)null);
                            }
                            return saslClient;
                        }
                        catch (SaslException e) {
                            throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_LOCAL_ERROR, e);
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof LdapException) {
                    throw (LdapException)e.getCause();
                }
                LocalizableMessage msg = CoreMessages.ERR_SASL_CONTEXT_CREATE_ERROR.get((Object)"GSSAPI", (Object)StaticUtils.getExceptionMessage(e));
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_LOCAL_ERROR, msg.toString(), e);
            }
        }

        @Override
        public void dispose() {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
        }

        @Override
        public boolean evaluateResult(BindResult result) throws LdapException {
            this.lastResult = result;
            try {
                return Subject.doAs(this.subject, this.evaluateAction);
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof LdapException) {
                    throw (LdapException)e.getCause();
                }
                LocalizableMessage msg = CoreMessages.ERR_SASL_PROTOCOL_ERROR.get((Object)"GSSAPI", (Object)StaticUtils.getExceptionMessage(e));
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_LOCAL_ERROR, msg.toString(), e);
            }
        }

        @Override
        public ConnectionSecurityLayer getConnectionSecurityLayer() {
            String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
            if ("auth-int".equalsIgnoreCase(qop) || "auth-conf".equalsIgnoreCase(qop)) {
                return this;
            }
            return null;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws LdapException {
            try {
                return this.saslClient.unwrap(incoming, offset, len);
            }
            catch (SaslException e) {
                LocalizableMessage msg = CoreMessages.ERR_SASL_PROTOCOL_ERROR.get((Object)"GSSAPI", (Object)StaticUtils.getExceptionMessage(e));
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_DECODING_ERROR, msg.toString(), e);
            }
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws LdapException {
            try {
                return this.saslClient.wrap(outgoing, offset, len);
            }
            catch (SaslException e) {
                LocalizableMessage msg = CoreMessages.ERR_SASL_PROTOCOL_ERROR.get((Object)"GSSAPI", (Object)StaticUtils.getExceptionMessage(e));
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_ENCODING_ERROR, msg.toString(), e);
            }
        }
    }
}

