/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.requests.AbstractRequestImpl;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.util.Reject;

final class CompareRequestImpl
extends AbstractRequestImpl<CompareRequest>
implements CompareRequest {
    private ByteString assertionValue;
    private AttributeDescription attributeDescription;
    private DN name;

    CompareRequestImpl(CompareRequest compareRequest) {
        super(compareRequest);
        this.name = compareRequest.getName();
        this.attributeDescription = compareRequest.getAttributeDescription();
        this.assertionValue = compareRequest.getAssertionValue();
    }

    CompareRequestImpl(DN name, AttributeDescription attributeDescription, ByteString assertionValue) {
        this.name = name;
        this.attributeDescription = attributeDescription;
        this.assertionValue = assertionValue;
    }

    @Override
    public ByteString getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public String getAssertionValueAsString() {
        return this.assertionValue.toString();
    }

    @Override
    public AttributeDescription getAttributeDescription() {
        return this.attributeDescription;
    }

    @Override
    public DN getName() {
        return this.name;
    }

    @Override
    public CompareRequest setAssertionValue(Object value) {
        Reject.ifNull((Object)value);
        this.assertionValue = ByteString.valueOfObject(value);
        return this;
    }

    @Override
    public CompareRequest setAttributeDescription(AttributeDescription attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        this.attributeDescription = attributeDescription;
        return this;
    }

    @Override
    public CompareRequest setAttributeDescription(String attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        this.attributeDescription = AttributeDescription.valueOf(attributeDescription);
        return this;
    }

    @Override
    public CompareRequest setName(DN dn) {
        Reject.ifNull((Object)dn);
        this.name = dn;
        return this;
    }

    @Override
    public CompareRequest setName(String dn) {
        Reject.ifNull((Object)dn);
        this.name = DN.valueOf(dn);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompareRequest(name=");
        builder.append(this.getName());
        builder.append(", attributeDescription=");
        builder.append(this.getAttributeDescription());
        builder.append(", assertionValue=");
        builder.append(this.getAssertionValueAsString());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    CompareRequest getThis() {
        return this;
    }
}

