/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.TreeMap;
import org.forgerock.opendj.ldap.AbstractMapEntry;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryFactory;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.util.Reject;

public final class TreeMapEntry
extends AbstractMapEntry {
    public static final EntryFactory FACTORY = new EntryFactory(){

        @Override
        public Entry newEntry(DN name) {
            return new TreeMapEntry(name);
        }
    };

    public static TreeMapEntry deepCopyOfEntry(Entry entry) {
        TreeMapEntry copy = new TreeMapEntry(entry.getName());
        for (Attribute attribute : entry.getAllAttributes()) {
            copy.addAttribute(new LinkedAttribute(attribute));
        }
        return copy;
    }

    public TreeMapEntry() {
        this(DN.rootDN());
    }

    public TreeMapEntry(DN name) {
        super((DN)Reject.checkNotNull((Object)name), new TreeMap<AttributeDescription, Attribute>());
    }

    public TreeMapEntry(Entry entry) {
        this(entry.getName());
        for (Attribute attribute : entry.getAllAttributes()) {
            this.addAttribute(attribute);
        }
    }

    public TreeMapEntry(String name) {
        this(DN.valueOf(name));
    }

    public TreeMapEntry(String ... ldifLines) {
        this(Requests.newAddRequest(ldifLines));
    }
}

