/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

public enum OperatingSystem {
    AIX("AIX", false, false, true),
    FREEBSD("FreeBSD", false, false, true),
    HPUX("HP UX", false, false, true),
    LINUX("Linux", false, false, true),
    MACOSX("Mac OS X", false, true, true),
    SOLARIS("Solaris", false, false, true),
    WINDOWS("Windows", true, false, false),
    WINDOWS7("Windows 7", true, false, false),
    WINDOWS_VISTA("Windows Vista", true, false, false),
    WINDOWS_SERVER_2008("Server 2008", true, false, false),
    ZOS("z/OS", false, false, false),
    UNKNOWN("Unknown", false, false, false);

    private String osName;
    private boolean isWindows;
    private boolean isMacOS;
    private boolean isUnixBased;
    private static final OperatingSystem INSTANCE;

    private OperatingSystem(String osName, boolean isWindows, boolean isMacOS, boolean isUnixBased) {
        this.osName = osName;
        this.isWindows = isWindows;
        this.isMacOS = isMacOS;
        this.isUnixBased = isUnixBased;
    }

    public String toString() {
        return this.osName;
    }

    public static OperatingSystem forName(String osName) {
        if (osName == null) {
            return UNKNOWN;
        }
        String lowerName = osName.toLowerCase();
        if (lowerName.contains("solaris") || lowerName.contains("sunos")) {
            return SOLARIS;
        }
        if (lowerName.contains("linux")) {
            return LINUX;
        }
        if (lowerName.contains("hp-ux") || lowerName.contains("hp ux") || lowerName.contains("hpux")) {
            return HPUX;
        }
        if (lowerName.contains("aix")) {
            return AIX;
        }
        if (lowerName.contains("windows")) {
            if (lowerName.indexOf("windows 7") != -1) {
                return WINDOWS7;
            }
            if (lowerName.indexOf("vista") != -1) {
                return WINDOWS_VISTA;
            }
            if (lowerName.indexOf("server 2008") != -1) {
                return WINDOWS_SERVER_2008;
            }
            return WINDOWS;
        }
        if (lowerName.contains("freebsd") || lowerName.contains("free bsd")) {
            return FREEBSD;
        }
        if (lowerName.contains("macos x") || lowerName.contains("mac os x")) {
            return MACOSX;
        }
        if (lowerName.contains("z/os")) {
            return ZOS;
        }
        return UNKNOWN;
    }

    public static OperatingSystem getOperatingSystem() {
        return INSTANCE;
    }

    public static boolean isWindows() {
        return OperatingSystem.INSTANCE.isWindows;
    }

    public static boolean isVista() {
        return INSTANCE == WINDOWS_VISTA;
    }

    public static boolean isWindows2008() {
        return INSTANCE == WINDOWS_SERVER_2008;
    }

    public static boolean isWindows7() {
        return INSTANCE == WINDOWS7;
    }

    public static boolean isMacOS() {
        return OperatingSystem.INSTANCE.isMacOS;
    }

    public static boolean isUnix() {
        return OperatingSystem.INSTANCE.isUnixBased;
    }

    public static boolean isUnixBased() {
        return OperatingSystem.INSTANCE.isUnixBased;
    }

    public static boolean isUnknown() {
        return INSTANCE == UNKNOWN;
    }

    public static boolean hasUAC() {
        return OperatingSystem.isVista() || OperatingSystem.isWindows2008() || OperatingSystem.isWindows7();
    }

    static {
        INSTANCE = OperatingSystem.forName(System.getProperty("os.name"));
    }
}

