/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.reactive.Completable;
import java.util.concurrent.CancellationException;
import org.forgerock.opendj.ldap.spi.LdapMessages;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class LdapResponseMessageWriter
implements Subscriber<LdapMessages.LdapResponseMessage>,
CompletionHandler {
    private final Connection<?> connection;
    private final Completable.Subscriber downstream;
    private Subscription upstream;

    LdapResponseMessageWriter(Connection<?> connection, Completable.Subscriber downstream) {
        this.connection = connection;
        this.downstream = downstream;
    }

    public void onSubscribe(Subscription s) {
        if (this.upstream != null) {
            s.cancel();
            return;
        }
        this.upstream = s;
        this.upstream.request(2L);
    }

    public void onNext(LdapMessages.LdapResponseMessage message) {
        this.connection.write((Object)message, (CompletionHandler)this);
    }

    public void completed(Object result) {
        this.upstream.request(1L);
    }

    public void cancelled() {
        this.failed(new CancellationException());
    }

    public void failed(Throwable error) {
        this.onError(error);
    }

    public void updated(Object result) {
    }

    public void onError(Throwable error) {
        this.upstream.cancel();
        this.downstream.onError(error);
    }

    public void onComplete() {
        this.upstream.cancel();
        this.downstream.onComplete();
    }
}

