/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.grizzly.GrizzlyMessages;
import com.forgerock.opendj.util.ReferenceCountedObject;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.DefaultTCPNIOTransport;
import org.forgerock.opendj.grizzly.GrizzlyLDAPConnection;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LDAPClientFilter;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TimeoutChecker;
import org.forgerock.opendj.ldap.TimeoutEventListener;
import org.forgerock.opendj.ldap.spi.LDAPConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.LDAPConnectionImpl;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.time.Duration;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class GrizzlyLDAPConnectionFactory
implements LDAPConnectionFactoryImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final LDAPClientFilter clientFilter;
    private final FilterChain defaultFilterChain;
    private final Options options;
    private final String host;
    private final int port;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final ReferenceCountedObject.Reference transport;
    private final ReferenceCountedObject.Reference timeoutChecker = TimeoutChecker.TIMEOUT_CHECKER.acquire();
    public static final Option<TCPNIOTransport> GRIZZLY_TRANSPORT = Option.of(TCPNIOTransport.class, null);

    public GrizzlyLDAPConnectionFactory(String host, int port, Options options) {
        this.transport = DefaultTCPNIOTransport.DEFAULT_TRANSPORT.acquireIfNull((TCPNIOTransport)options.get(GRIZZLY_TRANSPORT));
        this.host = host;
        this.port = port;
        this.options = options;
        this.clientFilter = new LDAPClientFilter((DecodeOptions)options.get(LDAPConnectionFactory.LDAP_DECODE_OPTIONS), 0);
        this.defaultFilterChain = GrizzlyUtils.buildFilterChain(((TCPNIOTransport)this.transport.get()).getProcessor(), new Filter[]{this.clientFilter});
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.releaseTransportAndTimeoutChecker();
        }
    }

    public Promise<LDAPConnectionImpl, LdapException> getConnectionAsync() {
        this.acquireTransportAndTimeoutChecker();
        TCPNIOConnectorHandler connectorHandler = ((TCPNIOConnectorHandler.Builder)TCPNIOConnectorHandler.builder((TCPNIOTransport)((TCPNIOTransport)this.transport.get())).processor((Processor)this.defaultFilterChain)).build();
        PromiseImpl promise = PromiseImpl.create();
        connectorHandler.connect((Object)this.getSocketAddress(), (CompletionHandler)new CompletionHandlerAdapter(promise));
        return promise;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getHostName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    TimeoutChecker getTimeoutChecker() {
        return (TimeoutChecker)this.timeoutChecker.get();
    }

    Options getLDAPOptions() {
        return this.options;
    }

    void releaseTransportAndTimeoutChecker() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.transport.release();
            this.timeoutChecker.release();
        }
    }

    private void acquireTransportAndTimeoutChecker() {
        this.referenceCount.incrementAndGet();
        if (this.isClosed.get()) {
            this.releaseTransportAndTimeoutChecker();
            throw new IllegalStateException("Attempted to get a connection after factory close");
        }
    }

    private final class CompletionHandlerAdapter
    implements CompletionHandler<Connection>,
    TimeoutEventListener {
        private final PromiseImpl<LDAPConnectionImpl, LdapException> promise;
        private final long timeoutEndTime;

        private CompletionHandlerAdapter(PromiseImpl<LDAPConnectionImpl, LdapException> promise) {
            this.promise = promise;
            long timeoutMS = this.getTimeout();
            this.timeoutEndTime = timeoutMS > 0L ? System.currentTimeMillis() + timeoutMS : 0L;
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).addListener((TimeoutEventListener)this);
        }

        public void cancelled() {
        }

        public void completed(Connection result) {
            GrizzlyLDAPConnection connection = this.adaptConnection(result);
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).removeListener((TimeoutEventListener)this);
            if (!this.promise.tryHandleResult((Object)connection)) {
                connection.close();
            }
        }

        public void failed(Throwable throwable) {
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).removeListener((TimeoutEventListener)this);
            this.promise.handleException((Exception)((Object)this.adaptConnectionException(throwable)));
            GrizzlyLDAPConnectionFactory.this.releaseTransportAndTimeoutChecker();
        }

        public void updated(Connection result) {
        }

        private GrizzlyLDAPConnection adaptConnection(Connection<?> connection) {
            GrizzlyUtils.configureConnection(connection, logger, GrizzlyLDAPConnectionFactory.this.options);
            connection.configureBlocking(true);
            GrizzlyLDAPConnection ldapConnection = new GrizzlyLDAPConnection(connection, GrizzlyLDAPConnectionFactory.this);
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).addListener((TimeoutEventListener)ldapConnection);
            GrizzlyLDAPConnectionFactory.this.clientFilter.registerConnection(connection, ldapConnection);
            return ldapConnection;
        }

        private LdapException adaptConnectionException(Throwable t) {
            if (!(t instanceof LdapException) && t instanceof ExecutionException) {
                Throwable throwable = t = t.getCause() != null ? t.getCause() : t;
            }
            if (t instanceof LdapException) {
                return (LdapException)t;
            }
            return LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_CONNECT_ERROR, (CharSequence)t.getMessage(), (Throwable)t);
        }

        public long handleTimeout(long currentTime) {
            if (this.timeoutEndTime == 0L) {
                return 0L;
            }
            if (this.timeoutEndTime > currentTime) {
                return this.timeoutEndTime - currentTime;
            }
            this.promise.handleException((Exception)((Object)LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_CONNECT_ERROR, (CharSequence)GrizzlyMessages.LDAP_CONNECTION_CONNECT_TIMEOUT.get((Object)GrizzlyLDAPConnectionFactory.this.getSocketAddress(), (Object)this.getTimeout()).toString())));
            return 0L;
        }

        public long getTimeout() {
            Duration duration = (Duration)GrizzlyLDAPConnectionFactory.this.options.get(LDAPConnectionFactory.CONNECT_TIMEOUT);
            return duration.isUnlimited() ? 0L : duration.to(TimeUnit.MILLISECONDS);
        }
    }
}

