/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.util.Reject;
import org.forgerock.util.thread.listener.ShutdownListener;
import org.forgerock.util.thread.listener.ShutdownManager;

public class ExecutorServiceFactory {
    private final ShutdownManager shutdownManager;

    public ExecutorServiceFactory(ShutdownManager shutdownManager) {
        this.shutdownManager = shutdownManager;
    }

    public ScheduledExecutorService createScheduledService(int poolSize) {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(poolSize);
        this.registerShutdown(service);
        return service;
    }

    public ExecutorService createFixedThreadPool(int pool, ThreadFactory factory) {
        ExecutorService service = Executors.newFixedThreadPool(pool, factory);
        this.registerShutdown(service);
        return service;
    }

    public ExecutorService createFixedThreadPool(int pool, String threadNamePrefix) {
        ExecutorService service = Executors.newFixedThreadPool(pool, new NamedThreadFactory(threadNamePrefix));
        this.registerShutdown(service);
        return service;
    }

    public ExecutorService createFixedThreadPool(int pool) {
        ExecutorService service = Executors.newFixedThreadPool(pool);
        this.registerShutdown(service);
        return service;
    }

    public ExecutorService createCachedThreadPool(ThreadFactory factory) {
        ExecutorService service = Executors.newCachedThreadPool(factory);
        this.registerShutdown(service);
        return service;
    }

    public ExecutorService createCachedThreadPool(String threadNamePrefix) {
        ExecutorService service = Executors.newCachedThreadPool(new NamedThreadFactory(threadNamePrefix));
        this.registerShutdown(service);
        return service;
    }

    public ExecutorService createCachedThreadPool() {
        ExecutorService service = Executors.newCachedThreadPool();
        this.registerShutdown(service);
        return service;
    }

    public ExecutorService createThreadPool(int coreSize, int maxSize, long idleTimeout, TimeUnit timeoutTimeunit, BlockingQueue<Runnable> runnables) {
        Reject.ifTrue(coreSize < 0);
        Reject.ifTrue(maxSize < coreSize || maxSize <= 0);
        Reject.ifTrue(idleTimeout < 0L);
        ThreadPoolExecutor service = new ThreadPoolExecutor(coreSize, maxSize, idleTimeout, timeoutTimeunit, runnables);
        this.registerShutdown(service);
        return service;
    }

    private void registerShutdown(final ExecutorService service) {
        this.shutdownManager.addShutdownListener(new ShutdownListener(){

            @Override
            public void shutdown() {
                service.shutdownNow();
            }
        });
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger count = new AtomicInteger(0);
        private final String name;

        public NamedThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, String.valueOf(this.name) + "-" + this.count.getAndIncrement());
        }
    }
}

