/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.i18n;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.forgerock.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferredLocales {
    private static final Locale DEFAULT_RESOURCE_BUNDLE_LOCALE = Locale.forLanguageTag(System.getProperty("org.forgerock.defaultBundleLocale", "en-US"));
    private static final Logger logger = LoggerFactory.getLogger(PreferredLocales.class);
    private final List<Locale> locales;
    private final int numberLocales;

    public PreferredLocales(List<Locale> locales) {
        if (locales == null || locales.isEmpty()) {
            locales = Collections.singletonList(Locale.ROOT);
        }
        this.locales = Collections.unmodifiableList(locales);
        this.numberLocales = locales.size();
    }

    public PreferredLocales() {
        this(null);
    }

    public Locale getPreferredLocale() {
        return this.locales.get(0);
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public ResourceBundle getBundleInPreferredLocale(String bundleName, ClassLoader classLoader) {
        logger.debug("Finding best {} bundle for locales {}", (Object)bundleName, this.locales);
        int i = 0;
        while (i < this.numberLocales) {
            List<Locale> remainingLocales;
            ResourceBundle candidate;
            Locale candidateLocale;
            Locale locale = this.locales.get(i);
            if (this.matches(locale, candidateLocale = (candidate = ResourceBundle.getBundle(bundleName, locale, classLoader)).getLocale(), remainingLocales = this.locales.subList(i + 1, this.numberLocales))) {
                logger.debug("Returning {} bundle in {} locale", (Object)bundleName, (Object)candidateLocale);
                return candidate;
            }
            if (!candidateLocale.equals(Locale.ROOT) && this.matches(locale, DEFAULT_RESOURCE_BUNDLE_LOCALE, remainingLocales)) {
                return ResourceBundle.getBundle(bundleName, Locale.ROOT, classLoader);
            }
            ++i;
        }
        logger.debug("Returning {} bundle in root locale", (Object)bundleName);
        return ResourceBundle.getBundle(bundleName, Locale.ROOT, classLoader);
    }

    private boolean matches(Locale requested, Locale candidate, List<Locale> remainingLocales) {
        logger.trace("Checking candidate locale {} for match with requested {}", (Object)candidate, (Object)requested);
        if (requested.equals(candidate)) {
            return true;
        }
        if (candidate.equals(Locale.ROOT)) {
            logger.trace("Rejecting root locale as it is the default. Requested {}", (Object)requested);
            return false;
        }
        String language = candidate.getLanguage();
        if (!requested.getLanguage().equals(language)) {
            return false;
        }
        String country = candidate.getCountry();
        String variant = candidate.getVariant();
        if (!Utils.isNullOrEmpty(variant) && remainingLocales.contains(new Locale(language, country, variant))) {
            return false;
        }
        if (!(Utils.isNullOrEmpty(country) && Utils.isNullOrEmpty(variant) || !remainingLocales.contains(new Locale(language, country)))) {
            return false;
        }
        return !remainingLocales.contains(new Locale(language));
    }
}

