/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.forgerock.json.JsonException;

public class JsonPointer
implements Iterable<String> {
    private String[] tokens = new String[0];

    public JsonPointer() {
    }

    public JsonPointer(String pointer) {
        String[] split = pointer.split("/", -1);
        int length = split.length;
        ArrayList<String> list = new ArrayList<String>(length);
        int n = 0;
        while (n < length) {
            if (!(n == 0 && split[n].length() == 0 || n == length - 1 && split[n].length() == 0)) {
                list.add(this.decode(split[n]));
            }
            ++n;
        }
        this.tokens = list.toArray(this.tokens);
    }

    public JsonPointer(String ... tokens) {
        this.tokens = Arrays.copyOf(tokens, tokens.length);
    }

    public JsonPointer(Iterable<String> iterable) {
        ArrayList<String> list = new ArrayList<String>();
        for (String element : iterable) {
            list.add(element);
        }
        this.tokens = list.toArray(this.tokens);
    }

    private String encode(String value) {
        try {
            return new URI(null, null, null, null, value).toASCIIString().substring(1).replaceAll("/", "%2F");
        }
        catch (URISyntaxException use) {
            throw new IllegalStateException(use.getMessage());
        }
    }

    private String decode(String value) {
        try {
            return new URI("#" + value).getFragment();
        }
        catch (URISyntaxException use) {
            throw new JsonException(use.getMessage());
        }
    }

    public int size() {
        return this.tokens.length;
    }

    public String get(int index) {
        if (index < 0 || index >= this.tokens.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.tokens[index];
    }

    public String[] toArray() {
        return Arrays.copyOf(this.tokens, this.tokens.length);
    }

    public JsonPointer parent() {
        JsonPointer parent = null;
        if (this.tokens.length > 0) {
            parent = new JsonPointer();
            parent.tokens = Arrays.copyOf(this.tokens, this.tokens.length - 1);
        }
        return parent;
    }

    public JsonPointer relativePointer() {
        return this.tokens.length > 0 ? this.relativePointer(this.tokens.length - 1) : this;
    }

    public JsonPointer relativePointer(int sz) {
        int length = this.tokens.length;
        if (sz < 0 || sz > length) {
            throw new IndexOutOfBoundsException();
        }
        if (sz == length) {
            return this;
        }
        if (sz == 0) {
            return new JsonPointer();
        }
        JsonPointer relativePointer = new JsonPointer();
        relativePointer.tokens = Arrays.copyOfRange(this.tokens, length - sz, length);
        return relativePointer;
    }

    public String leaf() {
        return this.tokens.length > 0 ? this.tokens[this.tokens.length - 1] : null;
    }

    public JsonPointer child(String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        JsonPointer pointer = new JsonPointer();
        pointer.tokens = Arrays.copyOf(this.tokens, this.tokens.length + 1);
        pointer.tokens[pointer.tokens.length - 1] = child;
        return pointer;
    }

    public JsonPointer child(int child) {
        if (child < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.child(Integer.toString(child));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < JsonPointer.this.tokens.length;
            }

            @Override
            public String next() {
                if (this.cursor >= JsonPointer.this.tokens.length) {
                    throw new NoSuchElementException();
                }
                return JsonPointer.this.tokens[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.tokens;
        int n = this.tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            sb.append('/').append(this.encode(token));
            ++n2;
        }
        if (sb.length() == 0) {
            sb.append('/');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        return o instanceof JsonPointer && ((JsonPointer)o).size() == this.size() && Arrays.equals(this.tokens, ((JsonPointer)o).tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }
}

