/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.rotation;

import org.forgerock.audit.rotation.RotatableObject;
import org.forgerock.audit.rotation.RotationPolicy;

public class SizeBasedRotationPolicy
implements RotationPolicy {
    private final long maxFileSizeInBytes;

    public SizeBasedRotationPolicy(long maxFileSizeInBytes) {
        this.maxFileSizeInBytes = maxFileSizeInBytes;
    }

    @Override
    public boolean shouldRotateFile(RotatableObject file) {
        return this.maxFileSizeInBytes > 0L && file.getBytesWritten() >= this.maxFileSizeInBytes;
    }

    public long getMaxFileSizeInBytes() {
        return this.maxFileSizeInBytes;
    }
}

