/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.rotation;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.forgerock.audit.rotation.RotatableObject;
import org.forgerock.audit.rotation.RotationPolicy;
import org.forgerock.util.time.Duration;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedTimeRotationPolicy
implements RotationPolicy {
    private static final Logger logger = LoggerFactory.getLogger(FixedTimeRotationPolicy.class);
    private final List<Duration> dailyRotationTimes;

    public FixedTimeRotationPolicy(List<Duration> rotationTimes) {
        this.dailyRotationTimes = rotationTimes;
    }

    @Override
    public boolean shouldRotateFile(RotatableObject rotatable) {
        DateTime currentTime = new DateTime();
        DateTime midnight = new DateMidnight().toDateTime();
        for (Duration dailyRotationTime : this.dailyRotationTimes) {
            DateTime nextRotationTime = midnight.plus(dailyRotationTime.to(TimeUnit.MILLISECONDS));
            if (!currentTime.isAfter((ReadableInstant)nextRotationTime) || !rotatable.getLastRotationTime().isBefore((ReadableInstant)nextRotationTime)) continue;
            return true;
        }
        return false;
    }

    public List<Duration> getDailyRotationTimes() {
        return this.dailyRotationTimes;
    }
}

