/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.DependencyProvider;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandler;
import org.forgerock.audit.events.handlers.AuditEventHandlerFactory;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;

public class DependencyProviderAuditEventHandlerFactory
implements AuditEventHandlerFactory {
    private final DependencyProvider dependencyProvider;

    public DependencyProviderAuditEventHandlerFactory(DependencyProvider dependencyProvider) {
        this.dependencyProvider = dependencyProvider;
    }

    @Override
    public <T extends AuditEventHandler> T create(String name, Class<T> clazz, EventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData) throws AuditException {
        Constructor<T> constructor = this.getConstructorForInjection(clazz);
        Object[] parameters = this.getConstructorParameters(constructor, name, configuration, eventTopicsMetaData);
        try {
            return (T)((AuditEventHandler)constructor.newInstance(parameters));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            String errorMessage = "Unable to create " + clazz.getSimpleName() + " '" + name + "': " + e.getMessage();
            throw new AuditException(errorMessage, e);
        }
    }

    private <T extends AuditEventHandler> Constructor<T> getConstructorForInjection(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        for (Constructor<?> candidateConstructor : constructors) {
            if (!this.hasInjectAnnotation(candidateConstructor)) continue;
            return candidateConstructor;
        }
        throw new IllegalStateException(clazz.getSimpleName() + " should have a single public constructor. If multiple public constructors are required, annotate one with @Inject.");
    }

    private boolean hasInjectAnnotation(Constructor<?> constructor) {
        for (Annotation annotation : constructor.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(Inject.class)) continue;
            return true;
        }
        return false;
    }

    private <T extends AuditEventHandler> Object[] getConstructorParameters(Constructor<T> constructor, String name, EventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData) throws AuditException {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].equals(String.class)) {
                parameters[i] = name;
                continue;
            }
            if (parameterTypes[i].isAssignableFrom(configuration.getClass())) {
                parameters[i] = configuration;
                continue;
            }
            if (parameterTypes[i].equals(EventTopicsMetaData.class)) {
                parameters[i] = eventTopicsMetaData;
                continue;
            }
            try {
                parameters[i] = this.dependencyProvider.getDependency(parameterTypes[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                parameters[i] = null;
            }
        }
        return parameters;
    }
}

