/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events;

import java.util.List;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.ResourceException;

public final class AuditEventHelper {
    private static final String PROPERTIES = "properties";
    public static final String STRING_TYPE = "string";
    public static final String OBJECT_TYPE = "object";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String NUMBER_TYPE = "number";
    public static final String ARRAY_TYPE = "array";
    private static final String TYPE = "type";
    private static final String SCHEMA = "schema";
    private static final String REQUIRED = "required";
    private static final String LOG_TO = "logTo";

    private AuditEventHelper() {
    }

    public static boolean isPropertyRequired(JsonValue auditEvent, JsonPointer property) {
        return auditEvent.get(SCHEMA).get(PROPERTIES).get(property).get(REQUIRED).defaultTo((Object)false).asBoolean();
    }

    public static String getPropertyType(JsonValue auditEvent, JsonPointer property) throws ResourceException {
        String[] pointers = property.toArray();
        JsonValue properties = auditEvent.get(SCHEMA);
        for (String pointer : pointers) {
            if ((properties = properties.get(PROPERTIES).get(pointer)) != null && !properties.isNull()) continue;
            throw new InternalServerErrorException("Unknown audit event property: " + property.toString());
        }
        return properties.get(TYPE).asString();
    }

    public static List<String> getConfiguredAuditEventHandlers(JsonValue auditEvent) {
        return auditEvent.get(LOG_TO).asList(String.class);
    }

    public static JsonValue getAuditEventProperties(JsonValue auditEvent) throws ResourceException {
        if (auditEvent == null || auditEvent.isNull()) {
            throw new InternalServerErrorException("Can't get properties for an undefined audit event");
        }
        return auditEvent.get(SCHEMA).get(PROPERTIES);
    }

    public static JsonValue getAuditEventSchema(JsonValue auditEvent) throws ResourceException {
        if (auditEvent == null || auditEvent.isNull()) {
            throw new InternalServerErrorException("Can't get the schema for an undefined audit event");
        }
        return auditEvent.get(SCHEMA);
    }

    public static String jsonPointerToDotNotation(String fieldName) {
        String newPath = fieldName;
        if (fieldName.startsWith("/")) {
            newPath = fieldName.substring(1);
        }
        return newPath == null ? null : newPath.replace('/', '.');
    }

    public static String dotNotationToJsonPointer(String fieldName) {
        return fieldName == null ? null : fieldName.replace('.', '/');
    }
}

