/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.AccumulatorState;
import com.persistit.Buffer;
import com.persistit.Persistit;
import com.persistit.SharedResource;
import com.persistit.TimelyResource;
import com.persistit.TreeStatistics;
import com.persistit.Version;
import com.persistit.Volume;
import com.persistit.exception.CorruptVolumeException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.RollbackException;
import com.persistit.exception.TimeoutException;
import com.persistit.util.Debug;
import com.persistit.util.Util;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class Tree
extends SharedResource {
    static final int MAX_SERIALIZED_SIZE = 512;
    static final int MAX_TREE_NAME_SIZE = 256;
    static final int MAX_ACCUMULATOR_COUNT = 64;
    private final String _name;
    private final Volume _volume;
    private final AtomicReference<Object> _appCache = new AtomicReference();
    private final AtomicInteger _handle = new AtomicInteger();
    private final TimelyResource<TreeVersion> _timelyResource;
    private final Version.VersionCreator<TreeVersion> _creator = new Version.VersionCreator<TreeVersion>(){

        @Override
        public TreeVersion createVersion(TimelyResource<? extends TreeVersion> resource) throws PersistitException {
            return new TreeVersion();
        }
    };

    Tree(Persistit persistit, Volume volume, String name) {
        super(persistit);
        int serializedLength = name.getBytes().length;
        if (serializedLength > 256) {
            throw new IllegalArgumentException("Tree name too long: " + name.length() + "(as " + serializedLength + " bytes)");
        }
        this._name = name;
        this._volume = volume;
        this._timelyResource = new TimelyResource(persistit);
    }

    TreeVersion version() {
        try {
            return this._timelyResource.getVersion(this._creator);
        }
        catch (PersistitException e) {
            throw new TreeVersionException(e);
        }
    }

    public boolean isDeleted() throws TimeoutException, PersistitInterruptedException {
        return this._timelyResource.isEmpty();
    }

    boolean isLive() throws TimeoutException, PersistitInterruptedException {
        return this.isValid() && !this.isDeleted();
    }

    boolean isTransactionPrivate(boolean byStep) throws TimeoutException, PersistitInterruptedException {
        return this._timelyResource.isTransactionPrivate(byStep);
    }

    boolean hasVersion(long versionHandle) throws TimeoutException, PersistitInterruptedException {
        return this._timelyResource.getVersion(versionHandle) != null;
    }

    void delete() throws RollbackException, PersistitException {
        this._timelyResource.delete();
    }

    public Volume getVolume() {
        return this._volume;
    }

    public String getName() {
        return this._name;
    }

    public int hashCode() {
        return this._volume.hashCode() ^ this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Tree) {
            Tree tree = (Tree)o;
            return this._name.equals(tree._name) && this._volume.equals(tree.getVolume());
        }
        return false;
    }

    public long getRootPageAddr() {
        TreeVersion version = this.version();
        return version._rootPageAddr;
    }

    public int getDepth() {
        return this.version()._depth;
    }

    @Override
    public long getGeneration() {
        return this.version()._generation;
    }

    @Override
    void bumpGeneration() {
        this.version()._generation = this._persistit.getTimestampAllocator().updateTimestamp();
    }

    void changeRootPageAddr(long rootPageAddr, int deltaDepth) throws PersistitException {
        Debug.$assert0.t(this.isOwnedAsWriterByMe());
        TreeVersion version = this.version();
        version._rootPageAddr = rootPageAddr;
        version._depth += deltaDepth;
    }

    void bumpChangeCount() {
        this.version()._changeCount.incrementAndGet();
    }

    long getChangeCount() {
        return this.version()._changeCount.get();
    }

    int store(byte[] bytes, int index) {
        byte[] nameBytes = Util.stringToBytes(this._name);
        TreeVersion version = this.version();
        Util.putLong(bytes, index, version._rootPageAddr);
        Util.putLong(bytes, index + 8, version._changeCount.get());
        Util.putShort(bytes, index + 16, version._depth);
        Util.putShort(bytes, index + 18, nameBytes.length);
        Util.putBytes(bytes, index + 20, nameBytes);
        return 20 + nameBytes.length;
    }

    int load(byte[] bytes, int index, int length) {
        int nameLength;
        int n = nameLength = length < 20 ? -1 : Util.getShort(bytes, index + 18);
        if (nameLength < 1 || nameLength + 20 > length) {
            throw new IllegalStateException("Invalid tree record is too short for tree " + this._name + ": " + length);
        }
        String name = new String(bytes, index + 20, nameLength);
        if (!this._name.equals(name)) {
            throw new IllegalStateException("Invalid tree name recorded: " + name + " for tree " + this._name);
        }
        TreeVersion version = this.version();
        version._rootPageAddr = Util.getLong(bytes, index);
        version._changeCount.set(Util.getLong(bytes, index + 8));
        version._depth = Util.getShort(bytes, index + 16);
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRootPageAddress(long rootPageAddr) throws PersistitException {
        TreeVersion version = this.version();
        if (version._rootPageAddr != rootPageAddr) {
            Buffer buffer = null;
            try {
                buffer = this.getVolume().getStructure().getPool().get(this._volume, rootPageAddr, false, true);
                int type = buffer.getPageType();
                if (type < 1 || type > 21) {
                    throw new CorruptVolumeException(String.format("Tree root page %,d has invalid type %s", rootPageAddr, buffer.getPageTypeName()));
                }
                version._rootPageAddr = rootPageAddr;
                version._depth = type - 1 + 1;
            }
            finally {
                if (buffer != null) {
                    buffer.releaseTouched();
                }
            }
        }
    }

    void invalidate() {
        TreeVersion version = this.version();
        super.clearValid();
        version._depth = -1;
        version._rootPageAddr = -1L;
        version._generation = this._persistit.getTimestampAllocator().updateTimestamp();
    }

    void setPrimordial() {
        this._timelyResource.setPrimordial();
    }

    public TreeStatistics getStatistics() {
        return this.version()._treeStatistics;
    }

    @Override
    public String toString() {
        TreeVersion version = this.version();
        return "<Tree " + this._name + " in volume " + this._volume.getName() + " rootPageAddr=" + version._rootPageAddr + " depth=" + version._depth + " status=" + this.getStatusDisplayString() + ">";
    }

    public void setAppCache(Object appCache) {
        this._appCache.set(appCache);
    }

    public Object getAppCache() {
        return this._appCache.get();
    }

    public int getHandle() {
        return this._handle.get();
    }

    void loadHandle() throws PersistitException {
        assert (!this._volume.isTemporary()) : "Handle allocation for temporary tree " + this;
        this._persistit.getJournalManager().handleForTree(this);
    }

    public Accumulator.SumAccumulator getSumAccumulator(int index) throws PersistitException {
        return (Accumulator.SumAccumulator)this.getAccumulator(Accumulator.Type.SUM, index);
    }

    public Accumulator.SeqAccumulator getSeqAccumulator(int index) throws PersistitException {
        return (Accumulator.SeqAccumulator)this.getAccumulator(Accumulator.Type.SEQ, index);
    }

    public Accumulator.MinAccumulator getMinAccumulator(int index) throws PersistitException {
        return (Accumulator.MinAccumulator)this.getAccumulator(Accumulator.Type.MIN, index);
    }

    public Accumulator.MaxAccumulator getMaxAccumulator(int index) throws PersistitException {
        return (Accumulator.MaxAccumulator)this.getAccumulator(Accumulator.Type.MAX, index);
    }

    synchronized Accumulator getAccumulator(Accumulator.Type type, int index) throws PersistitException {
        if (index < 0 || index >= 64) {
            throw new IllegalArgumentException("Invalid accumulator index: " + index);
        }
        TreeVersion version = this.version();
        Accumulator accumulator = version._accumulators[index];
        if (accumulator == null) {
            AccumulatorState saved = Accumulator.getAccumulatorState(this, index);
            long savedValue = 0L;
            if (saved != null) {
                if (!saved.getTreeName().equals(this.getName())) {
                    throw new IllegalStateException("AccumulatorState has wrong tree name: " + saved);
                }
                if (!saved.getType().equals((Object)type)) {
                    throw new IllegalStateException("AccumulatorState has different type: " + saved);
                }
                savedValue = saved.getValue();
            }
            ((TreeVersion)version)._accumulators[index] = accumulator = Accumulator.accumulator(type, this, index, savedValue, this._persistit.getTransactionIndex());
            this._persistit.addAccumulator(accumulator);
        } else if (accumulator.getType() != type) {
            throw new IllegalStateException("Wrong type " + accumulator + " is not a " + (Object)((Object)type) + " accumulator");
        }
        return accumulator;
    }

    int setHandle(int handle) {
        if (!this._handle.compareAndSet(0, handle)) {
            throw new IllegalStateException("Tree handle already set");
        }
        return handle;
    }

    void resetHandle() {
        this._handle.set(0);
    }

    public static class TreeVersionException
    extends RuntimeException {
        private static final long serialVersionUID = -6372589972106489591L;

        TreeVersionException(Exception e) {
            super(e);
        }
    }

    class TreeVersion
    implements Version.PrunableVersion {
        volatile long _rootPageAddr;
        volatile int _depth;
        volatile long _generation;
        final AtomicLong _changeCount;
        volatile boolean _pruned;
        private final Accumulator[] _accumulators;
        private final TreeStatistics _treeStatistics;

        TreeVersion() {
            this._generation = Tree.this._persistit.getTimestampAllocator().updateTimestamp();
            this._changeCount = new AtomicLong();
            this._accumulators = new Accumulator[64];
            this._treeStatistics = new TreeStatistics();
        }

        @Override
        public boolean prune() throws PersistitException {
            assert (!this._pruned);
            Tree.this._volume.getStructure().deallocateTree(this._rootPageAddr, this._depth);
            this.discardAccumulators();
            this._pruned = true;
            this._rootPageAddr = -1L;
            return true;
        }

        @Override
        public void vacate() {
            Tree.this.clearValid();
            Tree.this._volume.getStructure().removed(Tree.this);
        }

        public String toString() {
            return String.format("Tree(%d,%d)%s", this._rootPageAddr, this._depth, this._pruned ? "#" : "");
        }

        void discardAccumulators() {
            for (int i = 0; i < this._accumulators.length; ++i) {
                if (this._accumulators[i] == null) continue;
                Tree.this._persistit.removeAccumulator(this._accumulators[i]);
                this._accumulators[i] = null;
            }
        }
    }
}

