/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.Exchange;
import com.persistit.Persistit;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.CorruptVolumeException;
import com.persistit.exception.PersistitException;
import com.persistit.util.Debug;
import com.persistit.util.SequencerConstants;
import com.persistit.util.ThreadSequencer;
import com.persistit.util.Util;

class LongRecordHelper {
    final Persistit _persistit;
    final Volume _volume;
    final Exchange _exchange;

    LongRecordHelper(Persistit persistit, Volume volume) {
        this._persistit = persistit;
        this._volume = volume;
        this._exchange = null;
    }

    LongRecordHelper(Persistit persistit, Exchange exchange) {
        this._persistit = persistit;
        this._volume = exchange.getVolume();
        this._exchange = exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchLongRecord(Value value, int minimumBytesToFetch, long timeout) throws PersistitException {
        Buffer buffer = null;
        try {
            byte[] rawBytes = value.getEncodedBytes();
            int rawSize = value.getEncodedSize();
            if (rawSize != 120) {
                this.corrupt("Invalid LONG_RECORD value size=" + rawSize + " but should be " + 120);
            }
            if ((rawBytes[0] & 0xFF) != 255) {
                this.corrupt("Invalid LONG_RECORD value type=" + (rawBytes[0] & 0xFF) + " but should be " + 255);
            }
            int longSize = Buffer.decodeLongRecordDescriptorSize(rawBytes, 0);
            long startAtPage = Buffer.decodeLongRecordDescriptorPointer(rawBytes, 0);
            int remainingSize = Math.min(longSize, minimumBytesToFetch);
            value.ensureFit(remainingSize);
            value.setEncodedSize(remainingSize);
            int offset = 0;
            System.arraycopy(rawBytes, 20, value.getEncodedBytes(), offset, 100);
            offset += 100;
            remainingSize -= 100;
            long page = startAtPage;
            int count = 0;
            while (page != 0L && offset < minimumBytesToFetch) {
                int segmentSize;
                if (remainingSize <= 0) {
                    this.corrupt("Invalid LONG_RECORD remaining size=" + remainingSize + " of " + rawSize + " in page " + page);
                }
                if ((buffer = this._volume.getPool().get(this._volume, page, false, true, timeout)).getPageType() != 31) {
                    this.corrupt("LONG_RECORD chain is invalid at page " + page + " - invalid page type: " + buffer);
                }
                if ((segmentSize = buffer.getBufferSize() - 32) > remainingSize) {
                    segmentSize = remainingSize;
                }
                System.arraycopy(buffer.getBytes(), 32, value.getEncodedBytes(), offset, segmentSize);
                offset += segmentSize;
                remainingSize -= segmentSize;
                page = buffer.getRightSibling();
                buffer.releaseTouched();
                buffer = null;
                if (count > 5000 && count > 5000) {
                    this.corrupt("LONG_RECORD chain starting at " + startAtPage + " is too long");
                }
                ++count;
            }
            value.setLongSize(rawSize);
            value.setEncodedSize(offset);
        }
        finally {
            if (buffer != null) {
                buffer.releaseTouched();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long storeLongRecord(Value value, boolean inTxn) throws PersistitException {
        value.changeLongRecordMode(true);
        boolean completed = false;
        int longSize = value.getLongSize();
        byte[] longBytes = value.getLongBytes();
        byte[] rawBytes = value.getEncodedBytes();
        int maxSegmentSize = this._volume.getPool().getBufferSize() - 32;
        Debug.$assert0.t(value.isLongRecordMode());
        Debug.$assert0.t(rawBytes.length == 120);
        System.arraycopy(longBytes, 0, rawBytes, 20, 100);
        long looseChain = 0L;
        ThreadSequencer.sequence(SequencerConstants.LONG_RECORD_ALLOCATE_A);
        Buffer buffer = null;
        try {
            for (int offset = 100 + (longSize - 100 - 1) / maxSegmentSize * maxSegmentSize; offset >= 100; offset -= maxSegmentSize) {
                buffer = this._volume.getStructure().allocPage();
                long timestamp = this._persistit.getTimestampAllocator().updateTimestamp();
                buffer.writePageOnCheckpoint(timestamp);
                buffer.init(31);
                int segmentSize = longSize - offset;
                if (segmentSize > maxSegmentSize) {
                    segmentSize = maxSegmentSize;
                }
                Debug.$assert0.t(segmentSize >= 0 && offset >= 0 && offset + segmentSize <= longBytes.length && 32 + segmentSize <= buffer.getBytes().length);
                System.arraycopy(longBytes, offset, buffer.getBytes(), 32, segmentSize);
                int end = 32 + segmentSize;
                if (end < buffer.getBufferSize()) {
                    buffer.clearBytes(end, buffer.getBufferSize());
                }
                buffer.setRightSibling(looseChain);
                looseChain = buffer.getPageAddress();
                buffer.setDirtyAtTimestamp(timestamp);
                if (inTxn) {
                    buffer.writePage();
                }
                buffer.releaseTouched();
                buffer = null;
            }
            long page = looseChain;
            looseChain = 0L;
            Buffer.writeLongRecordDescriptor(value.getEncodedBytes(), longSize, page);
            completed = true;
            long l = page;
            return l;
        }
        finally {
            if (buffer != null) {
                buffer.releaseTouched();
            }
            if (looseChain != 0L) {
                this._volume.getStructure().deallocateGarbageChain(looseChain, 0L);
            }
            if (!completed) {
                value.changeLongRecordMode(false);
            }
        }
    }

    void corrupt(String error) throws CorruptVolumeException {
        Debug.$assert0.t(false);
        if (this._exchange != null) {
            this._persistit.getLogBase().corruptVolume.log(error + Util.NEW_LINE + this._exchange.toStringDetail());
        } else {
            this._persistit.getLogBase().corruptVolume.log(error);
        }
        throw new CorruptVolumeException(error);
    }
}

